/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GroupStatement
implements IStatement {
    private List ruleAttributes;
    private String name;
    private IParser parser;

    public GroupStatement() {
    }

    public GroupStatement(IParser parser) {
        this.parser = parser;
    }

    public void prepare(Element node, String path) throws PreparationException {
        this.name = path == null ? node.getAttribute(Messages.getString("HyadesGANameAttributeName")) : path + "." + node.getAttribute(Messages.getString("HyadesGANameAttributeName"));
        String index = node.getAttribute(Messages.getString("HyadesGAIndexAttributeName"));
        if (index != null && !index.equals("")) {
            this.name = this.name + "[" + index + "]";
        }
        NodeList children = node.getChildNodes();
        this.ruleAttributes = new ArrayList();
        int i = 0;
        while (i < children.getLength()) {
            block7: {
                IStatement statement;
                Element child = null;
                try {
                    child = (Element)children.item(i);
                }
                catch (ClassCastException e) {
                    break block7;
                }
                if (child.getNodeName().endsWith(Messages.getString("HyadesGARuleElementTagName"))) {
                    statement = new GroupStatement(this.parser);
                    statement.prepare(child, this.name);
                    this.ruleAttributes.add(statement);
                } else if (child.getNodeName().endsWith(Messages.getString("HyadesGARuleAttributeTagName"))) {
                    statement = new AttributeStatement(this.parser);
                    statement.prepare(child, this.name);
                    this.ruleAttributes.add(statement);
                }
            }
            ++i;
        }
    }

    public boolean run(String line, HashMap inputs, List outputs) throws AdapterException {
        if (this.ruleAttributes != null) {
            ListIterator iterator = this.ruleAttributes.listIterator();
            while (iterator.hasNext()) {
                IStatement statement = (IStatement)iterator.next();
                statement.run(line, inputs, outputs);
            }
        }
        return false;
    }
}

