/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;
    private String pathSeparator = System.getProperty("file.separator");

    public void stop() {
        super.stop();
        this.clean();
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String directory = null;
        String fileName = null;
        String converterCmdAttribute = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable sensorProperties = this.getProperties();
        if (sensorProperties != null && !sensorProperties.isEmpty()) {
            directory = (String)sensorProperties.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            fileName = (String)sensorProperties.get(Messages.getString("HyadesGAfileNameAttributeName"));
            converterCmdAttribute = (String)sensorProperties.get(Messages.getString("HyadesGAconverterCmdAttributeName"));
            this.converterShell = (String)sensorProperties.get(Messages.getString("HyadesGAconverterShellAttributeName"));
        } else {
            NodeList sensorNodes = element.getChildNodes();
            int i = 0;
            while (i < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item(i)).getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) {
                    sensorTypeInstance = sensorNode;
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        directory = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        fileName = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"))) {
                        converterCmdAttribute = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) {
                        this.converterShell = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
                    }
                }
                ++i;
            }
        }
        if (converterCmdAttribute != null && (converterCmdAttribute = converterCmdAttribute.trim()).length() == 0) {
            converterCmdAttribute = null;
        }
        if (this.converterShell != null) {
            this.converterShell = this.converterShell.trim();
            if (this.converterShell.length() == 0) {
                this.converterShell = null;
            }
        }
        if (directory == null || directory.trim().length() == 0 || fileName == null || fileName.trim().length() == 0 || converterCmdAttribute == null && !new File(directory, fileName).canRead()) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory.trim());
        this.setFileName(fileName.trim());
        this.setConverterCommand(converterCmdAttribute);
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] lineArray = new String[2];
        lineArray[0] = "test string";
        return lineArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null && !this.flushingMode) {
            this.rawLogFileName = this.getDirectory().endsWith(this.pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + this.pathSeparator + this.getFileName();
            if (this.rawLogFileName != null) {
                try {
                    if (this.input == null) {
                        this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                    }
                    this.input.prepare();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    this.log(event);
                }
            }
        }
        if (this.input != null) {
            int i = 0;
            while (i < this.maximumBlocking) {
                try {
                    this.lastLine[i] = this.input.readLine();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    this.log(event);
                }
                if (this.lastLine[i] == null) {
                    i = this.maximumBlocking;
                    this.rawLogFileName = null;
                }
                ++i;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)20);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final void setConverterCommand(String converterCmd) {
        this.converterCommand = converterCmd;
    }

    class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.reader.read() != -1) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Object object = SingleOSFileSensor.this.currentThreadLock;
            synchronized (object) {
                if (++SingleOSFileSensor.this.childThreadsDone == 2) {
                    SingleOSFileSensor.this.currentThreadLock.notify();
                }
            }
        }
    }

    private class BufferedPeriodicReader {
        private String filename = null;
        private String converter = null;
        private String shell = null;
        private RandomAccessFile currentFile = null;
        private File currentFileStat = null;
        long lastBookmark = 0L;
        long lastModified = 0L;
        byte[] historicInfo = null;
        private String machine = System.getProperty("os.name", "Windows");
        private boolean zOSMachine = this.machine.equals("z/OS") || this.machine.equals("OS/390");

        public BufferedPeriodicReader(String newFilename) {
            this(newFilename, null, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter) {
            this(newFilename, converter, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter, String shell) {
            this.filename = newFilename;
            this.converter = converter;
            this.shell = shell;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepare() {
            CommonBaseEvent event;
            if (this.converter != null && this.converter.length() > 0) {
                try {
                    Process converterProcess;
                    Object object = SingleOSFileSensor.this.currentThreadLock;
                    synchronized (object) {
                        SingleOSFileSensor.this.childThreadsDone = 0;
                        String platform = System.getProperty("os.name", null);
                        if (platform.startsWith("Windows")) {
                            converterProcess = Runtime.getRuntime().exec(this.converter);
                        } else if (platform.startsWith("AIX")) {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String[] cmdarr = new String[]{this.shell, this.converter};
                            converterProcess = Runtime.getRuntime().exec(cmdarr);
                        } else {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String converterCmd = this.shell + " " + this.converter;
                            converterProcess = Runtime.getRuntime().exec(converterCmd);
                        }
                        new ConverterOutputReader(converterProcess.getErrorStream()).start();
                        new ConverterOutputReader(converterProcess.getInputStream()).start();
                        try {
                            SingleOSFileSensor.this.currentThreadLock.wait(300000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    int exitValue = -1;
                    try {
                        exitValue = converterProcess.waitFor();
                    }
                    catch (InterruptedException i) {
                        converterProcess.destroy();
                    }
                    if (exitValue != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    SingleOSFileSensor.this.log(event);
                }
            }
            try {
                this.currentFileStat = new File(this.filename);
                if (this.currentFileStat.lastModified() > this.lastModified) {
                    this.currentFile = new RandomAccessFile(this.filename, "r");
                    this.lastModified = this.currentFileStat.lastModified();
                }
            }
            catch (Exception e) {
                this.currentFile = null;
            }
            if (this.lastBookmark != 0L && this.currentFile != null) {
                try {
                    long previousOffset = this.lastBookmark;
                    long currentOffset = this.currentFile.length();
                    long charactersToCompare = Math.min(Math.min((long)SingleOSFileSensor.this.confidenceBufferSize, previousOffset), currentOffset);
                    if (currentOffset >= previousOffset) {
                        boolean append = true;
                        int i = SingleOSFileSensor.this.fileFooterSize;
                        while ((long)i < charactersToCompare) {
                            this.currentFile.seek(previousOffset - 1L - (long)i);
                            char value = (char)this.currentFile.read();
                            if (this.historicInfo[i] != (byte)value) {
                                append = false;
                                break;
                            }
                            ++i;
                        }
                        if (append) {
                            this.currentFile.seek(previousOffset - (long)SingleOSFileSensor.this.fileFooterSize);
                            int i2 = SingleOSFileSensor.this.fileFooterSize - 1;
                            while (i2 >= 0) {
                                int value = this.currentFile.read();
                                if (this.historicInfo[i2] != (byte)value) break;
                                --i2;
                            }
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                    }
                    long matchedChars = 0L;
                    int historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                    long currentCurrentFileOffset = currentOffset -= (long)SingleOSFileSensor.this.fileFooterSize;
                    do {
                        this.currentFile.seek(--currentCurrentFileOffset);
                        if (this.historicInfo[historicInfoOffset++] == this.currentFile.read()) {
                            ++matchedChars;
                            continue;
                        }
                        currentCurrentFileOffset = --currentOffset;
                        historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                        matchedChars = 0L;
                    } while (matchedChars < charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize && currentOffset > 0L);
                    if (matchedChars == charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize) {
                        this.currentFile.seek(currentOffset);
                        int i = SingleOSFileSensor.this.fileFooterSize - 1;
                        while (i >= 0) {
                            int value = this.currentFile.read();
                            if (this.historicInfo[i] != (byte)value) {
                                this.historicInfo = null;
                                this.lastBookmark = this.currentFile.getFilePointer();
                                return;
                            }
                            --i;
                        }
                        this.historicInfo = null;
                        this.lastBookmark = currentOffset + (long)SingleOSFileSensor.this.fileFooterSize;
                        return;
                    }
                    this.historicInfo = null;
                    this.lastBookmark = 0L;
                    return;
                }
                catch (IOException e) {
                    event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    SingleOSFileSensor.this.log(event);
                }
            }
        }

        public void close() {
            try {
                if (this.currentFile != null) {
                    this.currentFile.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.currentFile = null;
        }

        public String readLine() throws IOException {
            if (this.currentFile != null) {
                String last = null;
                this.currentFile.seek(this.lastBookmark);
                if (this.currentFile != null) {
                    try {
                        if (this.zOSMachine) {
                            int size = (int)(this.currentFile.length() - this.lastBookmark) + 1;
                            byte[] buf = new byte[size];
                            int j = 0;
                            int i = 0;
                            while (i < size) {
                                byte a = (byte)this.currentFile.read();
                                if (a == -1) {
                                    j = -1;
                                    break;
                                }
                                if (a == 21) break;
                                buf[i] = a;
                                ++j;
                                ++i;
                            }
                            last = j == -1 ? null : new String(buf, 0, j);
                        } else {
                            last = this.currentFile.readLine();
                        }
                    }
                    catch (EOFException e) {
                        last = null;
                    }
                    catch (NullPointerException e) {
                        last = null;
                    }
                    if (last != null) {
                        this.lastBookmark = this.currentFile.getFilePointer();
                        return last;
                    }
                    int bytesToSave = (int)Math.min(this.currentFile.length(), (long)SingleOSFileSensor.this.confidenceBufferSize);
                    this.currentFile.seek(this.currentFile.length() - (long)bytesToSave);
                    this.historicInfo = new byte[bytesToSave];
                    int i = bytesToSave - 1;
                    while (i >= 0) {
                        this.historicInfo[i] = (byte)this.currentFile.read();
                        --i;
                    }
                    this.close();
                }
            }
            return null;
        }
    }
}

