/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner;

import java.util.ArrayList;
import org.eclipse.hyades.test.http.runner.HttpHeader;

public abstract class HttpElement {
    private String id = Integer.toString(this.hashCode());
    private String version;
    private ArrayList headers;
    private String body;

    public void addHeader(HttpHeader httpHeader) {
        if (HttpHeader.isValid(httpHeader)) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(httpHeader);
            httpHeader.setElement(this);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public HttpHeader[] getHeaders() {
        if (this.headers == null) {
            return new HttpHeader[0];
        }
        return this.headers.toArray(new HttpHeader[this.headers.size()]);
    }

    public HttpHeader[] getHeaders(String string) {
        if (string == null || this.headers == null) {
            return new HttpHeader[0];
        }
        ArrayList<HttpHeader> arrayList = new ArrayList<HttpHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!((HttpHeader)this.headers.get(i)).getName().equalsIgnoreCase(string)) continue;
            arrayList.add((HttpHeader)this.headers.get(i));
        }
        return arrayList.toArray(new HttpHeader[arrayList.size()]);
    }

    public void removeHeaders(String string) {
        if (string == null || this.headers == null) {
            return;
        }
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            if (!((HttpHeader)this.headers.get(i)).getName().equalsIgnoreCase(string)) continue;
            this.headers.remove((HttpHeader)this.headers.get(i));
        }
    }

    public String[] getHeaderValues(String string) {
        HttpHeader[] httpHeaderArray = this.getHeaders(string);
        if (httpHeaderArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[httpHeaderArray.length];
        for (int i = 0; i < httpHeaderArray.length; ++i) {
            stringArray[i] = httpHeaderArray[i].getValue();
        }
        return stringArray;
    }

    public int[] getHeaderIntValues(String string) {
        HttpHeader[] httpHeaderArray = this.getHeaders(string);
        if (httpHeaderArray == null) {
            return new int[0];
        }
        int[] nArray = new int[httpHeaderArray.length];
        for (int i = 0; i < httpHeaderArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(httpHeaderArray[i].getValue());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                nArray[i] = -1;
            }
        }
        return nArray;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public String getBody() {
        return this.body;
    }
}

