/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import org.eclipse.hyades.logging.adapter.util.AdapterMigrationException;
import org.eclipse.hyades.logging.adapter.util.IComponentMigrator;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SensorMigrator
implements IComponentMigrator {
    public Element migrate(Element oldSensorConfiguration) throws AdapterMigrationException {
        boolean migrated = false;
        Element newSensorConfiguration = null;
        try {
            Document doc = oldSensorConfiguration.getOwnerDocument();
            newSensorConfiguration = (Element)oldSensorConfiguration.cloneNode(false);
            if (newSensorConfiguration.hasAttribute(Messages.getString("HyadesGAtypeAttributeName"))) {
                newSensorConfiguration.removeAttribute(Messages.getString("HyadesGAtypeAttributeName"));
                migrated = true;
            }
            NodeList sensorNodes = oldSensorConfiguration.getChildNodes();
            for (int k = 0; k < sensorNodes.getLength(); ++k) {
                Element sensorProperty;
                String propertyValue;
                String propertyName;
                Element sensorNode;
                if (sensorNodes.item(k).getNodeType() != 1 || !(sensorNode = (Element)sensorNodes.item(k)).getTagName().equals(Messages.getString("HyadesGAStaticParserSensorTagName")) && !sensorNode.getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) continue;
                NamedNodeMap sensorTypeAttributeList = sensorNode.getAttributes();
                int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
                for (int j = 0; j < sensorTypeAttributeCount; ++j) {
                    Node sensorTypeAttribute = sensorTypeAttributeList.item(j);
                    propertyName = sensorTypeAttribute.getNodeName();
                    propertyValue = sensorTypeAttribute.getNodeValue();
                    sensorProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
                    sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), propertyValue);
                    sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), propertyName);
                    newSensorConfiguration.appendChild(sensorProperty);
                }
                NodeList sensorPropertyList = sensorNode.getElementsByTagName(Messages.getString("HyadesGASensorPropertyElementTagName"));
                int sensorPropertyCount = sensorPropertyList.getLength();
                for (int j = 0; j < sensorPropertyCount; ++j) {
                    Element oldSensorProperty = (Element)sensorPropertyList.item(j);
                    sensorProperty = doc.createElement(Messages.getString("HyadesGAPropertyElementTagName"));
                    propertyName = oldSensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyNameAttributeName"));
                    propertyValue = oldSensorProperty.getAttribute(Messages.getString("HyadesGASensorPropertyValueAttributeName"));
                    sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyValueAttributeName"), propertyValue);
                    sensorProperty.setAttribute(Messages.getString("HyadesGAPropertyNameAttributeName"), propertyName);
                    newSensorConfiguration.appendChild(sensorProperty);
                }
                if (sensorTypeAttributeCount <= 0 && sensorPropertyCount <= 0) continue;
                migrated = true;
            }
        }
        catch (Exception e) {
            throw new AdapterMigrationException("bad error", e);
        }
        if (!migrated) {
            newSensorConfiguration = null;
        }
        return newSensorConfiguration;
    }
}

