/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

class LoaderRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "loader";
    static final String ATT_ELEMENT_NAME = "elementName";
    static final String ATT_CLASS = "class";

    public LoaderRegistryReader() {
        super("fragment_loader");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADER)) {
            String elementName = element.getAttribute(ATT_ELEMENT_NAME);
            if (elementName == null) {
                this.logMissingAttribute(element, ATT_ELEMENT_NAME);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else if (LoaderExtensions.getInstance().containsKey(elementName)) {
                this.logError(element, "A loader for this element already exists, this loader will be ignored.");
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    LoaderExtensions.getInstance().put(elementName, (XMLFragmentLoader)classDescriptor.createInstance());
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

