/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfig;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Hosts;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.Plugin;
import org.eclipse.hyades.internal.config.generator.UserDefinition;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigFile
extends DefaultHandler {
    protected static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");
    private static String lineSeparator = System.getProperty("line.separator");
    protected DocumentBuilderFactory docBuildFactory = null;
    protected DocumentBuilder docBuild = null;
    protected Document doc = null;
    protected Element acConfig = null;
    protected Element holder = null;
    private int size = 100;
    private Hashtable hash = new Hashtable(this.size);
    private String sr = PlatformObject.sr;

    public ConfigFile() {
        this.docBuildFactory = DocumentBuilderFactory.newInstance();
        try {
            this.docBuild = this.docBuildFactory.newDocumentBuilder();
            this.createNewDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.err("Cannot create document builder");
        }
    }

    public ConfigFile(String fileName) {
        this();
        this.loadExistingDocument(fileName);
    }

    public void saveToFile() {
        String filename = new String(this.getValue("RASERVER_HOME") + this.sr + "config" + this.sr + "serviceconfig.xml");
        this.saveToFile(filename);
    }

    public void saveToFile(String fileName) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(fileName));
        }
        catch (Exception e) {
            Logger.err(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + fileName);
            Logger.err(e.getMessage());
        }
        if (writer != null) {
            writer.print(this.toString());
            writer.flush();
            writer.close();
        }
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        String encoding = PlatformObject.encoding;
        String version = "1.0";
        strbuf.append("<?xml");
        strbuf.append(" version=\"" + version + "\"");
        strbuf.append(" encoding=\"" + encoding + "\"");
        strbuf.append("?>" + lineSeparator);
        NodeList nodes = this.holder.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                strbuf.append(ConfigUtility.print(nodes.item(i)));
            }
        }
        return strbuf.toString();
    }

    public void generateConfiguration() {
        this.generateHyadesConfiguration();
    }

    public void generateHyadesConfiguration() {
        String sr = PlatformObject.sr;
        AgentControllerConfig.setVersion(this.acConfig, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setJvm(this.acConfig, this.resolveJvmDll(this.getValue("JAVA_PATH")));
        Element acEnv = this.doc.createElement(AgentControllerEnvironment.TAG);
        AgentControllerEnvironment.setConfiguration(acEnv, "default");
        this.acConfig.appendChild(acEnv);
        Element var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "JAVA_PATH");
        Variable.setValue(var, this.getValue("JAVA_PATH"));
        Variable.setPosition(var, "replace");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "RASERVER_HOME");
        Variable.setValue(var, this.getValue("RASERVER_HOME"));
        Variable.setPosition(var, "replace");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, PlatformObject.libEnv);
        Variable.setValue(var, "%RASERVER_HOME%" + sr + PlatformObject.libPath);
        Variable.setPosition(var, "prepend");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "SYS_TEMP_DIR");
        Variable.setValue(var, PlatformObject.tempDir);
        Variable.setPosition(var, "replace");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "LOCAL_AGENT_TEMP_DIR");
        Variable.setValue(var, "%SYS_TEMP_DIR%");
        Variable.setPosition(var, "replace");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "commons-logging.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hcframe.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hexcore.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hexl.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hexr.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hl14.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcommons.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcore.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlevents.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "hlcbe101.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "ecore.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        var = this.doc.createElement(Variable.TAG);
        Variable.setName(var, "CLASSPATH");
        Variable.setValue(var, "%RASERVER_HOME%" + sr + "lib" + sr + "common.jar");
        Variable.setPosition(var, "append");
        acEnv.appendChild(var);
        Element app = this.doc.createElement(Application.TAG);
        Application.setConfiguration(app, "default");
        Application.setExecutable(app, "java.exe");
        Application.setPath(app, "%JAVA_PATH%");
        Application.setLocation(app, "%SYS_TEMP_DIR%");
        this.acConfig.appendChild(app);
        Element hosts = this.doc.createElement(Hosts.TAG);
        Hosts.setConfiguration(hosts, "default");
        this.acConfig.appendChild(hosts);
        if (this.getValue("ALLOW") != null) {
            if (this.getValue("ALLOW").toLowerCase().equals("custom")) {
                String[] allowedHostList = ConfigUtility.stringToArray(this.getValue("HOSTS"));
                if (allowedHostList.length > 0) {
                    for (int i = 0; i < allowedHostList.length; ++i) {
                        Element allow = this.doc.createElement(Allow.TAG);
                        hosts.appendChild(allow);
                        if (allowedHostList[i].equalsIgnoreCase("all") || allowedHostList[i].equalsIgnoreCase("local")) {
                            Allow.setHost(allow, allowedHostList[i].toUpperCase());
                            continue;
                        }
                        Allow.setHost(allow, allowedHostList[i]);
                    }
                } else {
                    Element allow = this.doc.createElement(Allow.TAG);
                    Allow.setHost(allow, "LOCAL");
                    hosts.appendChild(allow);
                }
            } else {
                Element allow = this.doc.createElement(Allow.TAG);
                Allow.setHost(allow, this.getValue("ALLOW").toUpperCase());
                hosts.appendChild(allow);
            }
        } else {
            Element allow = this.doc.createElement(Allow.TAG);
            Allow.setHost(allow, "LOCAL");
            hosts.appendChild(allow);
        }
        Element plugin = this.doc.createElement(Plugin.TAG);
        Plugin.setPath(plugin, "%RASERVER_HOME%" + sr + "plugins");
        this.acConfig.appendChild(plugin);
    }

    public void createNewDocument() {
        DOMImplementation dom = this.docBuild.getDOMImplementation();
        this.doc = dom.createDocument(null, TAG, null);
        this.holder = this.doc.createElement("ElementHolder");
        this.acConfig = this.doc.createElement(AgentControllerConfig.TAG);
        AgentControllerConfig.setActiveConfiguration(this.acConfig, "default");
        AgentControllerConfig.setLoggingDetail(this.acConfig, "LOW");
        AgentControllerConfig.setLoggingLevel(this.acConfig, "INFORMATION");
        AgentControllerConfig.setPort(this.acConfig, "10002");
        AgentControllerConfig.setSecuredPort(this.acConfig, "10003");
        AgentControllerConfig.setVersion(this.acConfig, ConfigUtility.getString("Config.AgentController.Version"));
        AgentControllerConfig.setFilePort(this.acConfig, "10005");
        AgentControllerConfig.setProcessPolling(this.acConfig, "true");
        this.holder.appendChild(this.acConfig);
    }

    public void loadExistingDocument(String file) {
        block5: {
            SAXParser saxp = null;
            XMLReader parser = null;
            try {
                saxp = SAXParserFactory.newInstance().newSAXParser();
                parser = saxp.getXMLReader();
                parser.setContentHandler(this);
                parser.setErrorHandler(this);
            }
            catch (Exception e) {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.CreateParser") + " " + parser);
                Logger.err(e.getMessage());
            }
            if (parser != null) {
                try {
                    parser.parse(file);
                }
                catch (Exception e) {
                    Exception e1;
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.ParseFile") + " " + file);
                    Logger.err(e.getMessage());
                    if (!(e instanceof SAXException) || (e1 = ((SAXException)e).getException()) == null) break block5;
                    Logger.err(e1.getMessage());
                }
            }
        }
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (raw.equals(UserDefinition.TAG)) {
            String authenticationType = null;
            String name = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.UserDefinition.AuthenticationType.Tag"))) {
                    authenticationType = attrs.getValue(i);
                    continue;
                }
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.UserDefinition.Name.Tag"))) {
                    name = attrs.getValue(i);
                    continue;
                }
                Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attrs.getQName(i));
            }
            if (authenticationType != null && name != null) {
                this.setValue("SECURITY", "true");
                if (this.getValue("USERS") == null) {
                    this.setValue("USERS", name);
                } else {
                    this.setValue("USERS", this.getValue("USERS") + "," + name);
                }
            }
        } else if (raw.equals(Variable.TAG)) {
            String name = null;
            String value = null;
            String position = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.Variable.Name.Tag"))) {
                    name = attrs.getValue(i);
                    continue;
                }
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.Variable.Value.Tag"))) {
                    value = attrs.getValue(i);
                    continue;
                }
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.Variable.Position.Tag"))) {
                    position = attrs.getValue(i);
                    continue;
                }
                Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attrs.getQName(i));
            }
            if (name != null && value != null && position != null && !name.equals("CLASSPATH") && !name.equals("PATH")) {
                this.setValue(name, value);
            }
        } else if (raw.equals(Allow.TAG)) {
            String name = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equals(ConfigUtility.getString("Config.Allow.Host.Tag"))) {
                    name = attrs.getValue(i);
                    continue;
                }
                Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attrs.getQName(i));
            }
            if (name != null) {
                if (name.toLowerCase().equals("all") || name.toLowerCase().equals("local")) {
                    this.setValue("ALLOW", name.toUpperCase());
                    this.removeKey("HOSTS");
                } else {
                    this.setValue("ALLOW", "CUSTOM");
                    if (this.getValue("HOSTS") == null) {
                        this.setValue("HOSTS", name);
                    } else {
                        this.setValue("HOSTS", this.getValue("HOSTS") + "," + name);
                    }
                }
            }
        } else {
            Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedElement") + " " + local);
        }
    }

    public String resolveJvmDll(String string) {
        if (PlatformObject.name.equals("OS/400")) {
            return new String("QSYS/QJVAJNI");
        }
        int index = string.lastIndexOf(this.sr + "java" + PlatformObject.exeExt);
        if (index == -1 && (index = string.lastIndexOf(this.sr + "javaw" + PlatformObject.exeExt)) == -1) {
            return new String("%JAVA_PATH%");
        }
        String str = string.substring(0, index);
        String rc = null;
        try {
            rc = ConfigUtility.getJvmLib(str);
        }
        catch (Exception e) {
            Logger.out(ConfigUtility.getString("Config.Jvm.Warning.CannotFindJvmLibrary") + ": " + PlatformObject.jvmLib);
        }
        if (rc == null) {
            return new String("%JAVA_PATH%");
        }
        return rc;
    }

    public Element getAcConfig() {
        return this.acConfig;
    }

    public String getValue(String tag) {
        return (String)this.hash.get(tag);
    }

    public void setValue(String tag, String value) {
        this.hash.put(tag, value);
    }

    public void removeKey(String tag) {
        this.hash.remove(tag);
    }

    public boolean isExist(String tag) {
        return this.hash.containsKey(tag);
    }
}

