/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;

public abstract class Context
extends Component
implements IContext {
    private boolean continuousOperation = false;
    private long maximumIdleTime = 0L;
    private long pauseInterval = 0L;
    private long pauseCount = 0L;
    private boolean hardStop = false;
    protected IContextListener listener;

    public void stop() {
        super.stop();
        this.listener = null;
    }

    public void resetControledStop() {
        this.resetPauseCount();
    }

    public void resetPauseCount() {
        this.pauseCount = 0L;
    }

    public void incrementPauseCount() {
        ++this.pauseCount;
    }

    public long getPauseCount() {
        return this.pauseCount;
    }

    public void setPauseCount(long newPauseCount) {
        this.pauseCount = newPauseCount;
    }

    public void setContinuousOperation(boolean newContinuousOperation) {
        this.continuousOperation = newContinuousOperation;
    }

    public boolean getContinuousOperation() {
        return this.continuousOperation;
    }

    public void setMaximumIdleTime(long newMaximumIdleTime) {
        this.maximumIdleTime = newMaximumIdleTime;
    }

    public long getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setPauseInterval(long newPauseInterval) {
        this.pauseInterval = newPauseInterval;
    }

    public long getPauseInterval() {
        return this.pauseInterval;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        if (element.hasAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"))) {
            this.setContinuousOperation(Boolean.valueOf(element.getAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"))) {
            this.setPauseInterval(Long.valueOf(element.getAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"))) {
            this.setMaximumIdleTime(Long.valueOf(element.getAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControledStop() {
        if (!this.getContinuousOperation()) {
            this.hardStop = false;
            this.stop();
        } else if (this.getMaximumIdleTime() / this.getPauseInterval() >= this.getPauseCount()) {
            try {
                Context context = this;
                synchronized (context) {
                    Thread.sleep(this.getPauseInterval());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.incrementPauseCount();
        } else {
            this.hardStop = true;
            this.stop();
        }
    }

    public void setContextListener(IContextListener listener) {
        this.listener = listener;
    }

    public IContextListener getContextListener() {
        return this.listener;
    }

    protected boolean isHardStop() {
        return this.hardStop;
    }

    protected void setHardStop() {
        this.hardStop = true;
    }
}

