/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class FileUtil {
    public static File getTempDir() {
        GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
        String tmpdir = AccessController.doPrivileged(a);
        return new File(tmpdir);
    }

    public static boolean copyFile(String srcFile, String destFile) {
        try {
            FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
            FileChannel destChannel = new FileOutputStream(destFile).getChannel();
            destChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            destChannel.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static File[] listAllFiles(File srcDir) {
        Vector<File> files = new Vector<File>();
        File[] ret = new File[]{};
        File[] children = srcDir.listFiles();
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isFile()) {
                files.add(children[i]);
                continue;
            }
            File[] sub = FileUtil.listAllFiles(children[i]);
            for (int j = 0; j < sub.length; ++j) {
                files.add(sub[j]);
            }
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(ret);
    }

    public static boolean deltree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    FileUtil.deltree(children[i]);
                }
            }
            return root.delete();
        }
        return true;
    }
}

