/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.common.ExecutionResultData;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.fragments.BVRCombinedFragment;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.util.SaveManager;

public class ExecutionContext {
    public static final boolean debug = true;
    public static char separator = (char)46;
    public static String root = "ROOT";
    private TPFTestSuite testSuite = null;
    private ResourceSet resourceSet;
    private URI testSuiteURI;
    protected ExecutionResultData rootResult = null;
    protected HashMap resultMap = new HashMap();
    private Resource resource = null;
    private String executionResultLocation;
    private String executionResultName;
    protected EObjectCache cache = null;
    private int agentCount = 0;

    public ExecutionContext(TPFTestSuite suite, String id, String executionResultLocation, String executionResultName) {
        this(suite, id, executionResultLocation, executionResultName, false);
    }

    public ExecutionContext(TPFTestSuite suite, String id, CFGLocation location, String executionResultLocation, String executionResultName) {
        this(suite, id, executionResultLocation, executionResultName);
        this.rootResult.getResult().setDeployment(location.getDeployment());
    }

    public ExecutionContext(TPFTestSuite suite, String id, String executionResultLocation, String executionResultName, boolean overrideExisting) {
        this.testSuite = suite;
        this.resourceSet = suite.eResource().getResourceSet();
        this.testSuiteURI = EcoreUtil.getURI((EObject)this.testSuite);
        this.executionResultLocation = executionResultLocation;
        if (executionResultName == null) {
            this.executionResultName = suite.getName();
        }
        this.executionResultName = executionResultName;
        this.rootResult = new ExecutionResultData(this.getTestSuite(), suite.getId());
        this.resource = this.createExecutionResultResource(overrideExisting);
        this.resource.getContents().add((Object)this.rootResult.getResult());
        this.rootResult.getResult().setName(executionResultName);
        SaveManager.saveResource(this.resource);
        SaveManager.getInstance().addResource(this.resource);
        this.resultMap.put(this.getTestSuite().getId() + "(1)", this.rootResult);
        this.cache = new EObjectCache(0);
    }

    protected Resource createExecutionResultResource(long timestamp) {
        URI uri = this.getTestSuite().eResource().getURI().trimFileExtension();
        String filePath = this.getExecutionResultLocation() + "/" + uri.lastSegment() + "_" + timestamp + "." + "execution";
        URI executionResourceURI = null;
        executionResourceURI = RegistryReader.isPlatformMode() && !RegistryReader.isRCPMode() ? URI.createPlatformResourceURI((String)filePath) : URI.createFileURI((String)filePath);
        return this.getTestSuite().eResource().getResourceSet().createResource(executionResourceURI);
    }

    protected Resource createExecutionResultResource(boolean overrideExisting) {
        ResourceSet resourceSet;
        URI executionResourceURI;
        block4: {
            String filePath = this.getExecutionResultLocation() + "/" + this.getExecutionResultName();
            executionResourceURI = this.createURI(filePath);
            resourceSet = this.getTestSuite().eResource().getResourceSet();
            if (resourceSet == null) {
                LoadersUtils.log((String)("Can not create resource: " + filePath));
                return null;
            }
            try {
                InputStream in = resourceSet.getURIConverter().createInputStream(executionResourceURI);
                if (in == null) break block4;
                in.close();
                if (!overrideExisting) {
                    long timestamp = new Date().getTime();
                    this.setExecutionResultName(this.executionResultName + "_" + timestamp);
                    filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1) + this.getExecutionResultName();
                    executionResourceURI = this.createURI(filePath);
                }
            }
            catch (IOException e) {}
        }
        return resourceSet.createResource(executionResourceURI);
    }

    private URI createURI(String filePath) {
        if (RegistryReader.isPlatformMode() && !RegistryReader.isRCPMode()) {
            return URI.createPlatformResourceURI((String)filePath);
        }
        return URI.createFileURI((String)filePath);
    }

    public TPFTestSuite getTestSuite() {
        EObject eObject;
        if (this.testSuite.eResource().getResourceSet() == null && (eObject = this.resourceSet.getEObject(this.testSuiteURI, true)) instanceof TPFTestSuite) {
            this.testSuite = (TPFTestSuite)eObject;
        }
        return this.testSuite;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getExecutionResultLocation() {
        return this.executionResultLocation;
    }

    protected String getExecutionResultName() {
        return this.executionResultName + "." + "execution";
    }

    protected void setExecutionResultName(String name) {
        if (name.endsWith(".execution")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        this.executionResultName = name;
    }

    public void logEvent(TPFExecutionEvent event) {
        System.out.println("fall back to executionContext logger -- event " + event.toString());
        ExecutionMapData mapData = new ExecutionMapData(event.getOwnerId());
        ExecutionResultData data = mapData.getData();
        if (data == null) {
            this.reportErrorInEvent(event);
            return;
        }
        TPFExecutionHistory history = data.getHistory();
        event.setExecutionHistory(history);
        EObject eObject = data.getTest().eResource().getEObject(mapData.getOwnerId());
        if (event instanceof TPFInvocationEvent) {
            TPFTest test = this.getTestSuite();
            if (eObject instanceof BVRInteractionFragment) {
                event.setInteractionFragment((BVRInteractionFragment)eObject);
                TPFBehavior behavior = ((BVRExecutionOccurrence)eObject).getOtherBehavior();
                if (behavior.getTest() != null) {
                    test = behavior.getTest();
                }
            }
            ExecutionResultData child = new ExecutionResultData(test, event.getOwnerId());
            child.setInvocationEvent((TPFInvocationEvent)event);
            this.resultMap.put(child.getId(), child);
            ((TPFInvocationEvent)event).setExecutionHistory(data.getResult().getExecutionHistory());
        } else if (event instanceof TPFTypedEvent) {
            TPFTypedEvent type = (TPFTypedEvent)event;
            if (eObject instanceof TPFTest) {
                data.getResult().setTest((TPFTest)eObject);
            } else if (eObject instanceof BVRCombinedFragment) {
                event.setInteractionFragment((BVRInteractionFragment)eObject);
            }
        } else if (event instanceof TPFVerdictEvent) {
            data.getResult().setVerdict(((TPFVerdictEvent)event).getVerdict());
        }
    }

    private void reportErrorInEvent(TPFExecutionEvent event) {
        System.err.println("Ignoring the following event due to invalid ownerId: ");
        System.err.println("Event    : " + event.getClass().getName());
        System.err.println("ownerId  : " + event.getOwnerId());
        System.err.println("text     : " + event.getText());
        System.err.println("timestamp: " + event.getTimestamp());
    }

    public void cleanUp() {
        SaveManager.saveResource(this.resource);
        SaveManager.getInstance().removeResource(this.resource);
        this.resultMap.clear();
        this.cache.clear();
    }

    public EObject getEObjectByID(String id) {
        EObject obj = null;
        obj = this.cache.get(id);
        if (obj == null) {
            EObject newObj = this.resource.getEObject(id);
            this.cache.put(id, newObj);
            return newObj;
        }
        return obj;
    }

    public void putEObjectByID(String id, EObject obj) {
        this.cache.put(id, obj);
    }

    public int decrementAgentCount() {
        return --this.agentCount;
    }

    public void incrementAgentCount() {
        ++this.agentCount;
    }

    public class ExecutionMapData {
        String parentId = null;
        String ownerId = null;
        ExecutionResultData data = null;

        public ExecutionMapData(String id) {
            if (id == null || id.equals("")) {
                return;
            }
            int index = id.lastIndexOf(separator);
            if (index < 0) {
                this.parentId = id;
                this.ownerId = this.stripParanthesis(id);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null) {
                    String testSuiteId = ExecutionContext.this.getTestSuite().getId();
                    String testSuiteBehaviorId = ExecutionContext.this.getTestSuite().getBehavior().getId();
                    if (this.parentId.compareTo(testSuiteId) == 0 || this.parentId.compareTo(testSuiteBehaviorId) == 0) {
                        this.data = ExecutionContext.this.rootResult;
                    }
                }
            } else {
                ExecutionMapData map;
                ExecutionResultData tempData;
                this.ownerId = id.substring(index + 1);
                this.ownerId = this.stripParanthesis(this.ownerId);
                this.parentId = id.substring(0, index);
                this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                if (this.data == null && (tempData = (map = new ExecutionMapData(this.parentId)).getData()) != null) {
                    EObject eObject = tempData.getObjectInTest(map.getOwnerId());
                    if (eObject instanceof BVRCombinedFragment) {
                        this.data = tempData;
                    } else if (eObject instanceof TPFTest) {
                        this.data = tempData;
                    } else if (eObject instanceof BVRExecutionOccurrence) {
                        TPFInvocationEvent invocationEvent = Common_TestprofileFactory.eINSTANCE.createTPFInvocationEvent();
                        invocationEvent.setOwnerId(this.parentId);
                        ExecutionContext.this.logEvent(invocationEvent);
                        this.data = (ExecutionResultData)ExecutionContext.this.resultMap.get(this.parentId);
                    }
                }
            }
        }

        private String stripParanthesis(String id) {
            String str = id;
            int index = str.lastIndexOf(40);
            if (index >= 0) {
                str = str.substring(0, index);
            }
            return str;
        }

        public String getOwnerId() {
            return this.ownerId;
        }

        public String getParentId() {
            return this.parentId;
        }

        public ExecutionResultData getData() {
            return this.data;
        }
    }

    protected class EObjectCache {
        private LinkedList order = null;
        private Hashtable map = new Hashtable(89);
        private int capacity = 0;

        public EObjectCache(int size) {
            this.order = new LinkedList();
            this.capacity = size == 0 ? Integer.MAX_VALUE : size;
        }

        public void clear() {
            this.map.clear();
            this.order.clear();
        }

        public EObject get(String id) {
            Object obj = this.map.get(id);
            if (obj != null) {
                this.moveToFront(id);
                return (EObject)obj;
            }
            return null;
        }

        public void put(String id, EObject obj) {
            Object temp = this.map.get(id);
            if (temp != null) {
                this.moveToFront(id);
            } else {
                if (this.atCapacity()) {
                    this.removeLast();
                }
                this.insert(id, obj);
            }
        }

        private void insert(String id, EObject obj) {
            this.map.put(id, obj);
            if (this.capacity != Integer.MAX_VALUE) {
                this.order.add(0, id);
            }
        }

        private void moveToFront(String id) {
            int index;
            if (this.capacity != Integer.MAX_VALUE && (index = this.order.indexOf(id)) > 0) {
                Object obj = this.order.get(index);
                this.order.remove(index);
                this.order.addFirst(obj);
            }
        }

        private void removeLast() {
            if (this.capacity != Integer.MAX_VALUE) {
                String deadID = (String)this.order.getLast();
                this.map.remove(deadID);
                this.order.removeLast();
            }
        }

        private boolean atCapacity() {
            return this.map.size() >= this.capacity;
        }
    }
}

