/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.sensors;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.impl.Sensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SingleOSFileSensor
extends Sensor {
    private String directory = null;
    private String fileName = null;
    private String converterCommand = null;
    private String converterShell = null;
    private String rawLogFileName = null;
    private BufferedPeriodicReader input = null;
    private String[] lastLine = new String[this.maximumBlocking];
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;
    private String pathSeparator = System.getProperty("file.separator");
    private String charset;
    private boolean multi = false;
    private MultipleFilesReader mfr = null;
    private RandomAccessFile tmpLog = null;
    private File tmpFile = null;
    private static String prefix = "hgla";
    private static int timeout = 5;
    private static int MAX_CHAR = 1024;
    private String EOL_CHARS = System.getProperty("line.separator");
    private char EOL_LAST_CHAR = (char)(System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? 21 : (int)this.EOL_CHARS.charAt(this.EOL_CHARS.length() - 1));

    public SingleOSFileSensor() {
        try {
            this.tmpFile = File.createTempFile(prefix, null);
            this.tmpLog = new RandomAccessFile(this.tmpFile, "rws");
        }
        catch (Exception e) {
            this.tmpLog = null;
        }
    }

    public void stop() {
        super.stop();
        this.clean();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update() throws AdapterInvalidConfig {
        void var9_11;
        super.update();
        this.lastLine = new String[this.maximumBlocking];
        String directory = null;
        String fileName = null;
        String converterCmdAttribute = null;
        Element sensorTypeInstance = null;
        Element element = this.getConfiguration();
        Hashtable sensorProperties = this.getProperties();
        if (sensorProperties != null && !sensorProperties.isEmpty()) {
            directory = (String)sensorProperties.get(Messages.getString("HyadesGAdirectoryAttributeName"));
            fileName = (String)sensorProperties.get(Messages.getString("HyadesGAfileNameAttributeName"));
            converterCmdAttribute = (String)sensorProperties.get(Messages.getString("HyadesGAconverterCmdAttributeName"));
            this.converterShell = (String)sensorProperties.get(Messages.getString("HyadesGAconverterShellAttributeName"));
        } else {
            void var9_9;
            NodeList sensorNodes = element.getChildNodes();
            boolean bl = false;
            while (var9_9 < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item((int)var9_9).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item((int)var9_9)).getTagName().equals(Messages.getString("HyadesGASingleFileSensorTagName"))) {
                    sensorTypeInstance = sensorNode;
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
                        directory = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
                        fileName = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"))) {
                        converterCmdAttribute = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterCmdAttributeName"));
                    }
                    if (sensorTypeInstance.hasAttribute(Messages.getString("HyadesGAconverterShellAttributeName"))) {
                        this.converterShell = sensorTypeInstance.getAttribute(Messages.getString("HyadesGAconverterShellAttributeName"));
                    }
                }
                ++var9_9;
            }
        }
        if (converterCmdAttribute != null && (converterCmdAttribute = converterCmdAttribute.trim()).length() == 0) {
            converterCmdAttribute = null;
        }
        if (this.converterShell != null) {
            this.converterShell = this.converterShell.trim();
            if (this.converterShell.length() == 0) {
                this.converterShell = null;
            }
        }
        this.mfr = new MultipleFilesReader(directory, fileName);
        this.mfr.init();
        if (this.mfr.size() <= 1) {
            this.multi = false;
            if (this.mfr.size() != 1) throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
            String fn = this.mfr.getNext();
            if (directory == null || directory.trim().length() == 0 || fn == null || fn.trim().length() == 0 || converterCmdAttribute == null && !new File(fn).canRead()) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
            }
            this.setFileName(new File(fn).getName());
        } else {
            this.multi = true;
            if (directory == null || directory.trim().length() == 0 || fileName == null || fileName.trim().length() == 0) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileSensor_Invalid_Config_File_ERROR_"));
            }
            this.setFileName(this.tmpFile.getAbsolutePath());
            this.mfr.start();
        }
        this.setDirectory(directory.trim());
        this.setConverterCommand(converterCmdAttribute);
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.setMsg(Messages.getString("HyadesGASensor_SingleOSFileSensor_Configuration_INFO_", this.getFileName(), this.getDirectory(), this.getConverterCommand()));
        event.setSeverity((short)10);
        this.log(event);
        SingleOSFileSensor singleOSFileSensor = this;
        while (var9_11 != null) {
            if (var9_11 instanceof IContext) {
                this.charset = ((IContext)var9_11).getCharset();
                break;
            }
            IComponent iComponent = var9_11.getParent();
        }
        if (this.charset != null) return;
        this.charset = System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? "IBM-1047" : "UTF-8";
    }

    public Object[] testGetNext() {
        return this.testGetNextLine();
    }

    public String[] testGetNextLine() {
        String[] lineArray = new String[2];
        lineArray[0] = "test string";
        return lineArray;
    }

    public Object[] getNext() {
        if (this.rawLogFileName == null && !this.flushingMode) {
            this.rawLogFileName = this.multi ? this.getFileName() : (this.getDirectory().endsWith(this.pathSeparator) ? this.getDirectory() + this.getFileName() : this.getDirectory() + this.pathSeparator + this.getFileName());
            if (this.rawLogFileName != null) {
                try {
                    if (this.input == null) {
                        this.input = new BufferedPeriodicReader(this.rawLogFileName, this.converterCommand, this.converterShell);
                    }
                    this.input.prepare();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    this.log(event);
                }
            }
        }
        if (this.input != null) {
            int i = 0;
            while (i < this.maximumBlocking) {
                try {
                    this.lastLine[i] = this.input.readLine();
                }
                catch (Exception e) {
                    CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    this.log(event);
                }
                if (this.lastLine[i] == null) {
                    i = this.maximumBlocking;
                    this.rawLogFileName = null;
                }
                ++i;
            }
        }
        if (this.lastLine[0] != null) {
            return this.lastLine;
        }
        return null;
    }

    public void clean() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            this.mfr.interrupt();
            if (this.tmpLog != null) {
                try {
                    this.tmpLog.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.tmpFile.delete();
        }
        catch (Exception e) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.setMsg(e.toString());
            event.setSeverity((short)20);
            this.log(event);
        }
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getConverterCommand() {
        return this.converterCommand;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final void setConverterCommand(String converterCmd) {
        this.converterCommand = converterCmd;
    }

    private class MultipleFilesReader
    extends Thread {
        private String dirName;
        private String fileName_regex;
        private Vector files;
        private int index;

        public MultipleFilesReader(String dir, String f) {
            this.dirName = dir;
            this.fileName_regex = f;
            this.setName("MultipleFilesReader");
        }

        public void init() {
            if (this.dirName != null) {
                File dir = new File(this.dirName);
                File[] allFiles = dir.listFiles();
                if (this.fileName_regex != null) {
                    this.files = new Vector();
                    Pattern pat = Pattern.compile(this.fileName_regex);
                    int i = 0;
                    while (i < allFiles.length) {
                        Matcher mat = pat.matcher(allFiles[i].getName());
                        if (mat.matches()) {
                            boolean added = false;
                            int j = 0;
                            while (j < this.files.size() && !added) {
                                File f = new File((String)this.files.elementAt(j));
                                if (allFiles[i].lastModified() < f.lastModified()) {
                                    this.files.insertElementAt(this.dirName + File.separator + allFiles[i].getName(), j);
                                    added = true;
                                }
                                ++j;
                            }
                            if (!added) {
                                this.files.add(this.dirName + File.separator + allFiles[i].getName());
                            }
                        }
                        ++i;
                    }
                }
            }
            this.reset();
        }

        public void reset() {
            this.index = 0;
        }

        public int size() {
            return this.files.size();
        }

        public boolean hasNext() {
            return this.index < this.files.size();
        }

        public String getNext() {
            if (this.index < this.files.size()) {
                return (String)this.files.elementAt(this.index++);
            }
            return null;
        }

        public void run() {
            String previousFileName = null;
            String currentFileName = null;
            RandomAccessFile previousFile = null;
            RandomAccessFile currentFile = null;
            byte[] buf = null;
            int bufLen = 0;
            int byteCopied = 0;
            if (SingleOSFileSensor.this.tmpLog != null) {
                while (this.hasNext()) {
                    previousFileName = currentFileName;
                    currentFileName = this.getNext();
                    byteCopied = this.appendToTempFile(currentFileName);
                }
                buf = new byte[MAX_CHAR];
                this.bzero(buf);
                bufLen = 0;
                while (currentFileName != null) {
                    try {
                        currentFile = new RandomAccessFile(currentFileName, "r");
                        if (currentFile.length() < (long)byteCopied) {
                            previousFile = new RandomAccessFile(previousFileName, "r");
                            previousFile.seek(byteCopied);
                            if ((long)byteCopied < previousFile.length()) {
                                while ((long)byteCopied < previousFile.length()) {
                                    SingleOSFileSensor.this.tmpLog.write(previousFile.readByte());
                                    ++byteCopied;
                                }
                            }
                            previousFile.close();
                            byteCopied = 0;
                        }
                        currentFile.seek(byteCopied);
                        if ((long)byteCopied < currentFile.length()) {
                            while ((long)byteCopied < currentFile.length()) {
                                byte a = currentFile.readByte();
                                buf[bufLen++] = a;
                                if (a == SingleOSFileSensor.this.EOL_LAST_CHAR) {
                                    SingleOSFileSensor.this.tmpLog.write(buf, 0, bufLen);
                                    this.bzero(buf);
                                    bufLen = 0;
                                }
                                ++byteCopied;
                            }
                        }
                        currentFile.close();
                        Thread.sleep(timeout * 1000);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            } else {
                return;
            }
        }

        private void bzero(byte[] buffer) {
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = 0;
                ++i;
            }
        }

        private synchronized int appendToTempFile(String src) {
            int len;
            block2: {
                len = 0;
                byte[] buf = null;
                if (SingleOSFileSensor.this.tmpLog == null) break block2;
                try {
                    RandomAccessFile in = new RandomAccessFile(src, "r");
                    SingleOSFileSensor.this.tmpLog.seek(SingleOSFileSensor.this.tmpLog.length());
                    len = (int)in.length();
                    buf = new byte[len];
                    in.read(buf, 0, len);
                    SingleOSFileSensor.this.tmpLog.write(buf);
                    in.close();
                }
                catch (Exception e) {}
            }
            return len;
        }
    }

    class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.reader.read() != -1) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Object object = SingleOSFileSensor.this.currentThreadLock;
            synchronized (object) {
                if (++SingleOSFileSensor.this.childThreadsDone == 2) {
                    SingleOSFileSensor.this.currentThreadLock.notify();
                }
            }
        }
    }

    private class BufferedPeriodicReader {
        private String filename = null;
        private String converter = null;
        private String shell = null;
        private RandomAccessFile currentFile = null;
        private File currentFileStat = null;
        long lastBookmark = 0L;
        long lastModified = 0L;
        byte[] historicInfo = null;

        public BufferedPeriodicReader(String newFilename) {
            this(newFilename, null, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter) {
            this(newFilename, converter, null);
        }

        public BufferedPeriodicReader(String newFilename, String converter, String shell) {
            this.filename = newFilename;
            this.converter = converter;
            this.shell = shell;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepare() {
            CommonBaseEvent event;
            if (this.converter != null && this.converter.length() > 0) {
                try {
                    Process converterProcess;
                    Object object = SingleOSFileSensor.this.currentThreadLock;
                    synchronized (object) {
                        String converterCmd;
                        SingleOSFileSensor.this.childThreadsDone = 0;
                        String platform = System.getProperty("os.name", null);
                        if (platform.startsWith("Windows")) {
                            converterProcess = Runtime.getRuntime().exec(this.converter);
                        } else if (platform.startsWith("Linux")) {
                            converterCmd = this.shell == null ? this.converter : this.shell + " " + this.converter;
                            converterProcess = Runtime.getRuntime().exec(converterCmd);
                        } else if (platform.startsWith("AIX")) {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            String[] cmdarr = new String[]{this.shell, this.converter};
                            converterProcess = Runtime.getRuntime().exec(cmdarr);
                        } else {
                            if (this.shell == null) {
                                this.shell = "sh";
                            }
                            converterCmd = this.shell + " " + this.converter;
                            converterProcess = Runtime.getRuntime().exec(converterCmd);
                        }
                        new ConverterOutputReader(converterProcess.getErrorStream()).start();
                        new ConverterOutputReader(converterProcess.getInputStream()).start();
                        try {
                            SingleOSFileSensor.this.currentThreadLock.wait(300000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    int exitValue = -1;
                    try {
                        exitValue = converterProcess.waitFor();
                    }
                    catch (InterruptedException i) {
                        converterProcess.destroy();
                    }
                    if (exitValue != 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)50);
                    SingleOSFileSensor.this.log(event);
                }
            }
            try {
                this.currentFileStat = new File(this.filename);
                if (this.currentFileStat.lastModified() > this.lastModified) {
                    this.currentFile = new RandomAccessFile(this.filename, "r");
                    this.lastModified = this.currentFileStat.lastModified();
                }
            }
            catch (Exception e) {
                this.currentFile = null;
            }
            if (this.lastBookmark != 0L && this.currentFile != null) {
                try {
                    long previousOffset = this.lastBookmark;
                    long currentOffset = this.currentFile.length();
                    long charactersToCompare = Math.min(Math.min((long)SingleOSFileSensor.this.confidenceBufferSize, previousOffset), currentOffset);
                    if (currentOffset >= previousOffset) {
                        boolean append = true;
                        int i = SingleOSFileSensor.this.fileFooterSize;
                        while ((long)i < charactersToCompare) {
                            this.currentFile.seek(previousOffset - 1L - (long)i);
                            char value = (char)this.currentFile.read();
                            if (this.historicInfo[i] != (byte)value) {
                                append = false;
                                break;
                            }
                            ++i;
                        }
                        if (append) {
                            this.currentFile.seek(previousOffset - (long)SingleOSFileSensor.this.fileFooterSize);
                            int i2 = SingleOSFileSensor.this.fileFooterSize - 1;
                            while (i2 >= 0) {
                                int value = this.currentFile.read();
                                if (this.historicInfo[i2] != (byte)value) break;
                                --i2;
                            }
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                    }
                    long matchedChars = 0L;
                    int historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                    long currentCurrentFileOffset = currentOffset -= (long)SingleOSFileSensor.this.fileFooterSize;
                    do {
                        this.currentFile.seek(--currentCurrentFileOffset);
                        if (this.historicInfo[historicInfoOffset++] == this.currentFile.read()) {
                            ++matchedChars;
                            continue;
                        }
                        currentCurrentFileOffset = --currentOffset;
                        historicInfoOffset = SingleOSFileSensor.this.fileFooterSize;
                        matchedChars = 0L;
                    } while (matchedChars < charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize && currentOffset > 0L);
                    if (matchedChars == charactersToCompare - (long)SingleOSFileSensor.this.fileFooterSize) {
                        this.currentFile.seek(currentOffset);
                        int i = SingleOSFileSensor.this.fileFooterSize - 1;
                        while (i >= 0) {
                            int value = this.currentFile.read();
                            if (this.historicInfo[i] != (byte)value) {
                                this.historicInfo = null;
                                this.lastBookmark = this.currentFile.getFilePointer();
                                return;
                            }
                            --i;
                        }
                        this.historicInfo = null;
                        this.lastBookmark = currentOffset + (long)SingleOSFileSensor.this.fileFooterSize;
                        return;
                    }
                    this.historicInfo = null;
                    this.lastBookmark = 0L;
                    return;
                }
                catch (IOException e) {
                    event = SingleOSFileSensor.this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(e.toString());
                    event.setSeverity((short)30);
                    SingleOSFileSensor.this.log(event);
                }
            }
        }

        public void close() {
            try {
                if (this.currentFile != null) {
                    this.currentFile.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.currentFile = null;
        }

        public String readLine() throws IOException {
            boolean endOfFile = false;
            if (this.currentFile != null) {
                String last = null;
                this.currentFile.seek(this.lastBookmark);
                if (this.currentFile != null) {
                    try {
                        int size = (int)(this.currentFile.length() - this.lastBookmark) + 1;
                        byte[] buf = new byte[size];
                        int j = 0;
                        int i = 0;
                        block3: while (i < size) {
                            int a = this.currentFile.read();
                            if (a == -1) {
                                endOfFile = true;
                                break;
                            }
                            if (a == SingleOSFileSensor.this.EOL_LAST_CHAR) {
                                if (SingleOSFileSensor.this.EOL_CHARS.length() > 1 && j > 0) {
                                    int k = SingleOSFileSensor.this.EOL_CHARS.length() - 2;
                                    while (k >= 0) {
                                        if ((byte)SingleOSFileSensor.this.EOL_CHARS.charAt(k) != buf[j - 1]) break block3;
                                        buf[--j] = 0;
                                        --k;
                                    }
                                    break;
                                }
                                if (j <= 0 || SingleOSFileSensor.this.EOL_LAST_CHAR != '\n' || buf[j - 1] != 13) break;
                                buf[--j] = 0;
                                break;
                            }
                            buf[i] = (byte)a;
                            ++j;
                            ++i;
                        }
                        last = j == 0 && endOfFile ? null : new String(buf, 0, j, SingleOSFileSensor.this.charset);
                    }
                    catch (EOFException e) {
                        last = null;
                    }
                    catch (NullPointerException e) {
                        last = null;
                    }
                    if (endOfFile) {
                        int bytesToSave = (int)Math.min(this.currentFile.length(), (long)SingleOSFileSensor.this.confidenceBufferSize);
                        this.currentFile.seek(this.currentFile.length() - (long)bytesToSave);
                        this.historicInfo = new byte[bytesToSave];
                        int i = bytesToSave - 1;
                        while (i >= 0) {
                            this.historicInfo[i] = (byte)this.currentFile.read();
                            --i;
                        }
                        if (!SingleOSFileSensor.this.multi) {
                            this.close();
                        }
                    } else {
                        this.lastBookmark = this.currentFile.getFilePointer();
                    }
                    return last;
                }
            }
            return null;
        }
    }
}

