/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.util.BufferedPeriodicReader;
import org.eclipse.hyades.logging.adapter.util.MultipleFilesReader;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class MonitoringParser
extends Parser {
    protected BufferedPeriodicReader input;
    private boolean endOfFile = true;
    private boolean multi = false;
    private MultipleFilesReader mfr = null;
    private RandomAccessFile tmpLog = null;
    private File tmpFile = null;
    private static String prefix = "hgla";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfiguration(Hashtable table) throws LogParserException {
        this.file_path = null;
        try {
            this.tmpFile = File.createTempFile(prefix, null);
            this.tmpLog = new RandomAccessFile(this.tmpFile, "rws");
        }
        catch (Exception e) {
            this.tmpLog = null;
        }
        this.logFile = null;
        try {
            Integer array_size;
            this.file_path = (String)table.get("file_path");
            if (this.file_path != null) {
                this.file_path = ParserConstants.FILE_SEPARATOR_CHARACTER == '/' ? this.file_path.replace('\\', ParserConstants.FILE_SEPARATOR_CHARACTER) : this.file_path.replace('/', ParserConstants.FILE_SEPARATOR_CHARACTER);
                String fName = this.file_path.substring(this.file_path.lastIndexOf(ParserConstants.FILE_SEPARATOR_CHARACTER) + 1);
                String dirPath = this.file_path.substring(0, this.file_path.indexOf(fName) - 1);
                if (fName == null || dirPath == null) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                File dir = new File(dirPath);
                if (!dir.exists() || !dir.isDirectory()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                this.mfr = new MultipleFilesReader(dirPath, fName, this.tmpLog);
                this.mfr.init();
                if (this.mfr.size() <= 1) {
                    this.multi = false;
                    if (this.mfr.size() != 1) throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                    this.file_path = this.mfr.getNext();
                } else {
                    this.multi = true;
                    this.file_path = this.tmpFile.getAbsolutePath();
                    this.mfr.start();
                }
                File file = new File(this.file_path);
                if (!file.isFile()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_INVALID_FILE_NAME_ERROR_", this.file_path));
                }
                if (!file.canRead()) {
                    throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_CANNOT_READ_FILE_ERROR_", this.file_path));
                }
                this.input = new BufferedPeriodicReader(this.file_path);
                Integer confBufSize = (Integer)table.get("confidence_buffer_size");
                Integer fileFooterSize = (Integer)table.get("file_footer_size");
                this.charset = (String)table.get("characater_set");
                this.fileLocale = (Locale)table.get("locale");
                if (this.charset != null) {
                    this.input.setCharset(this.charset);
                }
                if (confBufSize != null) {
                    this.input.setConfidenceBufferSize(confBufSize.intValue());
                }
                if (fileFooterSize != null) {
                    this.input.setFileFooterSize(fileFooterSize.intValue());
                }
                this.input.setMultiFile(this.multi);
            }
            if ((array_size = (Integer)table.get("array_size")) != null) {
                this.MessageArraySize = array_size;
            }
            this.messages = new CommonBaseEvent[this.MessageArraySize];
            int i = 0;
            while (i < this.MessageArraySize) {
                this.messages[i] = Parser.eventFactory.createCommonBaseEvent();
                ++i;
            }
            return;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, ParserUtilities.getResourceString("REMOTE_LOG_PARSER_CONFIG_PARAMETER_ERROR_"));
        }
    }

    public void postParse() throws LogParserException {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception e) {
            ParserUtilities.exceptionHandler(e, "");
        }
    }

    protected String readLine() {
        String msgLine = null;
        if (this.endOfFile) {
            try {
                this.input.prepare();
                this.endOfFile = false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            msgLine = this.input.readLine();
            if (msgLine != null) {
                ++this.curLineNumber;
            }
        }
        catch (IOException i) {}
        return msgLine;
    }

    protected void setEndOfFile() {
        this.endOfFile = true;
    }
}

