/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoaderExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;

class LoadersFactoryRegistryReader
extends RegistryReader {
    static final String TAG_LOADERS_FACTORY = "loadersFactory";
    static final String ATT_CLASS = "class";

    public LoadersFactoryRegistryReader() {
        super("fragment_loaders_factory");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADERS_FACTORY)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                try {
                    IHyadesPluginClassDescriptor factoryClassDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    XMLFragmentLoadersFactory factory = (XMLFragmentLoadersFactory)factoryClassDescriptor.createInstance();
                    Set elements = factory.getSupportedElements();
                    Iterator iter = elements.iterator();
                    while (iter.hasNext()) {
                        String elementName = (String)iter.next();
                        if (LoaderExtensions.getInstance().containsKey(elementName)) {
                            this.logError(element, "A loader for this element already exists, this loader will be ignored.");
                            continue;
                        }
                        try {
                            XMLFragmentLoader loader = (XMLFragmentLoader)factory.getClass().getClassLoader().loadClass(factory.getLoaderClassName(elementName)).newInstance();
                            if (loader == null) continue;
                            LoaderExtensions.getInstance().put(elementName, loader);
                        }
                        catch (Exception e) {
                            this.logError(element, e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

