/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;

public class DPLDatapoolImpl
extends CFGClassImpl
implements DPLDatapool {
    public static final String copyright = "";
    protected EList equivalenceClasses = null;
    protected DPLDatapoolSpec datapoolSpec = null;
    protected int defaultEquivalenceClass = 0;
    protected IDatapoolListener listener = null;
    String absoluteFilePathname;
    static /* synthetic */ Class class$org$eclipse$hyades$models$common$datapool$DPLEquivalenceClass;

    protected DPLDatapoolImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.eINSTANCE.getDPLDatapool();
    }

    public EList getEquivalenceClasses() {
        if (this.equivalenceClasses == null) {
            this.equivalenceClasses = new EObjectContainmentEList(class$org$eclipse$hyades$models$common$datapool$DPLEquivalenceClass == null ? (class$org$eclipse$hyades$models$common$datapool$DPLEquivalenceClass = DPLDatapoolImpl.class$("org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass")) : class$org$eclipse$hyades$models$common$datapool$DPLEquivalenceClass, (InternalEObject)this, 6);
        }
        return this.equivalenceClasses;
    }

    public DPLDatapoolSpec getDatapoolSpec() {
        return this.datapoolSpec;
    }

    public NotificationChain basicSetDatapoolSpec(DPLDatapoolSpec newDatapoolSpec, NotificationChain msgs) {
        DPLDatapoolSpec oldDatapoolSpec = this.datapoolSpec;
        this.datapoolSpec = newDatapoolSpec;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldDatapoolSpec, (Object)newDatapoolSpec);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setDatapoolSpec(DPLDatapoolSpec newDatapoolSpec) {
        if (newDatapoolSpec != this.datapoolSpec) {
            NotificationChain msgs = null;
            if (this.datapoolSpec != null) {
                msgs = ((InternalEObject)this.datapoolSpec).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newDatapoolSpec != null) {
                msgs = ((InternalEObject)newDatapoolSpec).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetDatapoolSpec(newDatapoolSpec, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newDatapoolSpec, (Object)newDatapoolSpec));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return ((InternalEList)this.getOperations()).basicAdd((Object)otherEnd, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getInstances()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getInstantiations()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return ((InternalEList)this.getOperations()).basicRemove((Object)otherEnd, msgs);
                }
                case 4: {
                    return ((InternalEList)this.getInstances()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getInstantiations()).basicRemove((Object)otherEnd, msgs);
                }
                case 6: {
                    return ((InternalEList)this.getEquivalenceClasses()).basicRemove((Object)otherEnd, msgs);
                }
                case 7: {
                    return this.basicSetDatapoolSpec(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getOperations();
            }
            case 4: {
                return this.getInstances();
            }
            case 5: {
                return this.getInstantiations();
            }
            case 6: {
                return this.getEquivalenceClasses();
            }
            case 7: {
                return this.getDatapoolSpec();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getOperations().clear();
                this.getOperations().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getInstances().clear();
                this.getInstances().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getInstantiations().clear();
                this.getInstantiations().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getEquivalenceClasses().clear();
                this.getEquivalenceClasses().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setDatapoolSpec((DPLDatapoolSpec)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId(CMNNamedElementImpl.ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(CMNNamedElementImpl.DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(CMNNamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getOperations().clear();
                return;
            }
            case 4: {
                this.getInstances().clear();
                return;
            }
            case 5: {
                this.getInstantiations().clear();
                return;
            }
            case 6: {
                this.getEquivalenceClasses().clear();
                return;
            }
            case 7: {
                this.setDatapoolSpec(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return CMNNamedElementImpl.ID_EDEFAULT == null ? this.id != null : !CMNNamedElementImpl.ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return CMNNamedElementImpl.DESCRIPTION_EDEFAULT == null ? this.description != null : !CMNNamedElementImpl.DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return CMNNamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !CMNNamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.operations != null && !this.operations.isEmpty();
            }
            case 4: {
                return this.instances != null && !this.instances.isEmpty();
            }
            case 5: {
                return this.instantiations != null && !this.instantiations.isEmpty();
            }
            case 6: {
                return this.equivalenceClasses != null && !this.equivalenceClasses.isEmpty();
            }
            case 7: {
                return this.datapoolSpec != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String getLocation() {
        return null;
    }

    public ITest getOwner() {
        return null;
    }

    public String getResource() {
        return null;
    }

    public void setLocation(String location) {
    }

    public void setResource(String resource) {
    }

    public void updateVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int variableIndex) {
        this.removeVariableDoNotNotify(variableIndex);
        this.insertVariableDoNotNotify(variable, variableIndex);
        if (this.listener != null) {
            this.listener.variableChanged((IDatapool)this, variableIndex);
        }
    }

    public void insertVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int beforeVariableIndex) {
        this.insertVariableDoNotNotify(variable, beforeVariableIndex);
        if (this.listener != null) {
            this.listener.variableAdded((IDatapool)this, beforeVariableIndex);
        }
    }

    protected void insertVariableDoNotNotify(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable, int beforeVariableIndex) {
        this.getDatapoolSpec().getVariables().add(beforeVariableIndex, (Object)variable);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                DPLCell newCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
                newCell.setVariable((DPLVariable)variable);
                ((DPLRecordImpl)rec).insertCell(newCell, beforeVariableIndex);
            }
        }
    }

    public void appendVariable(org.eclipse.hyades.edit.datapool.IDatapoolVariable variable) {
        this.insertVariable(variable, this.getDatapoolSpec().getVariables().size());
    }

    public void moveVariable(int sourceVariableIndex, int targetVariableIndex) {
        DPLVariable var = (DPLVariable)this.getDatapoolSpec().getVariables().remove(sourceVariableIndex);
        this.getDatapoolSpec().getVariables().add(targetVariableIndex, (Object)var);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                DPLCell cell = (DPLCell)rec.getCells().remove(sourceVariableIndex);
                rec.getCells().add(targetVariableIndex, (Object)cell);
            }
        }
        if (this.listener != null) {
            this.listener.variableMoved((IDatapool)this, sourceVariableIndex, targetVariableIndex);
        }
    }

    public void removeVariable(int variableIndex) {
        this.removeVariableDoNotNotify(variableIndex);
        if (this.listener != null) {
            this.listener.variableRemoved((IDatapool)this, variableIndex);
        }
    }

    protected void removeVariableDoNotNotify(int variableIndex) {
        this.getDatapoolSpec().getVariables().remove(variableIndex);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                rec.getCells().remove(variableIndex);
            }
        }
    }

    public void setDefaultEquivalenceClassIndex(int equivalenceClassIndex) {
        this.defaultEquivalenceClass = equivalenceClassIndex;
    }

    public void updateEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int equivalenceClassIndex) {
        this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
        this.insertEquivalenceClassDoNotNotify(equivalenceClass, equivalenceClassIndex);
        if (this.listener != null) {
            this.listener.equivalenceClassChanged((IDatapool)this, equivalenceClassIndex);
        }
    }

    public void insertEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
        this.insertEquivalenceClassDoNotNotify(equivalenceClass, beforeEquivalenceClassIndex);
        if (this.listener != null) {
            this.listener.equivalenceClassAdded((IDatapool)this, beforeEquivalenceClassIndex);
        }
    }

    protected void insertEquivalenceClassDoNotNotify(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
        this.getEquivalenceClasses().add(beforeEquivalenceClassIndex, (Object)equivalenceClass);
    }

    public void appendEquivalenceClass(org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass equivalenceClass) {
        this.insertEquivalenceClass(equivalenceClass, this.getEquivalenceClasses().size());
    }

    public void moveEquivalenceClass(int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {
        if (this.listener != null) {
            this.listener.equivalenceClassMoved((IDatapool)this, sourceEquivalenceClassIndex, targetEquivalenceClassIndex);
        }
        DPLEquivalenceClass ec = (DPLEquivalenceClass)this.getEquivalenceClasses().get(sourceEquivalenceClassIndex);
        if (sourceEquivalenceClassIndex > targetEquivalenceClassIndex) {
            this.removeEquivalenceClassDoNotNotify(sourceEquivalenceClassIndex);
            this.insertEquivalenceClassDoNotNotify(ec, targetEquivalenceClassIndex + 1);
        } else {
            this.removeEquivalenceClassDoNotNotify(sourceEquivalenceClassIndex);
            this.insertEquivalenceClassDoNotNotify(ec, targetEquivalenceClassIndex);
        }
    }

    public void removeEquivalenceClass(int equivalenceClassIndex) {
        this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
        if (this.listener != null) {
            this.listener.equivalenceClassRemoved((IDatapool)this, equivalenceClassIndex);
        }
    }

    protected void removeEquivalenceClassDoNotNotify(int equivalenceClassIndex) {
        this.getEquivalenceClasses().remove(equivalenceClassIndex);
    }

    public void addDatapoolListener(IDatapoolListener listener) {
        this.listener = listener;
    }

    public IDatapoolListener getDatapoolListener() {
        return this.listener;
    }

    public void removeDatapoolListener(IDatapoolListener listener) {
        this.listener = null;
    }

    public int getVariableCount() {
        if (this.getDatapoolSpec() == null) {
            DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
            this.setDatapoolSpec(datapoolSpec);
        }
        return this.getDatapoolSpec().getVariables().size();
    }

    public IDatapoolVariable getVariable(int variableIndex) {
        if (this.getDatapoolSpec() == null) {
            DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
            this.setDatapoolSpec(datapoolSpec);
        }
        return (org.eclipse.hyades.edit.datapool.IDatapoolVariable)this.getDatapoolSpec().getVariables().get(variableIndex);
    }

    public int getVariableIndex(String variableName) {
        ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
        while (it.hasNext()) {
            DPLVariable var = (DPLVariable)it.next();
            if (!variableName.equals(var.getName())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    public int getVariableIndexById(String variableId) {
        ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
        while (it.hasNext()) {
            DPLVariable var = (DPLVariable)it.next();
            if (!variableId.equals(var.getId())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    public int getEquivalenceClassCount() {
        return this.getEquivalenceClasses().size();
    }

    public IDatapoolEquivalenceClass getEquivalenceClass(int index) {
        return (IDatapoolEquivalenceClass)this.getEquivalenceClasses().get(index);
    }

    public int getDefaultEquivalenceClassIndex() {
        return this.defaultEquivalenceClass;
    }

    public int getEquivalenceClassIndex(String equivalenceClassName) {
        ListIterator it = this.getEquivalenceClasses().listIterator();
        while (it.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)it.next();
            if (!equivalenceClassName.equals(ec.getName())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    public int getEquivalenceClassIndexById(String equivalenceClassId) {
        ListIterator it = this.getEquivalenceClasses().listIterator();
        while (it.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)it.next();
            if (!equivalenceClassId.equals(ec.getId())) continue;
            return it.previousIndex();
        }
        return -1;
    }

    public void logDatapoolAsStrings() {
        DPLLogImpl.log("Datapool " + this.getName() + " **********************************");
        DPLLogImpl.log(copyright);
        ListIterator varIter = this.getDatapoolSpec().getVariables().listIterator();
        DPLLogImpl.log("Variables: ");
        while (varIter.hasNext()) {
            DPLLogImpl.log("      " + ((DPLVariable)varIter.next()).getName());
        }
        DPLLogImpl.log(copyright);
        ListIterator ecIter = this.getEquivalenceClasses().listIterator();
        while (ecIter.hasNext()) {
            DPLEquivalenceClass ec = (DPLEquivalenceClass)ecIter.next();
            DPLLogImpl.log("EC: " + ec.getName());
            ListIterator recIter = ec.getRecords().listIterator();
            while (recIter.hasNext()) {
                DPLRecord rec = (DPLRecord)recIter.next();
                ListIterator cellIter = rec.getCells().listIterator();
                while (cellIter.hasNext()) {
                    DPLLogImpl.log("      " + ((DPLCell)cellIter.next()).getValue());
                }
                DPLLogImpl.log(copyright);
            }
            DPLLogImpl.log(copyright);
        }
        DPLLogImpl.log("End of  " + this.getName() + " **********************************");
        DPLLogImpl.log(copyright);
    }

    void setAbsoluteFilePathname(String absoluteFilePathname) {
        this.absoluteFilePathname = absoluteFilePathname;
    }

    void unsetAbsoluteFilePathname() {
        this.absoluteFilePathname = null;
    }

    String getAbsoluteFilePathname() {
        return this.absoluteFilePathname;
    }

    public org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass constructEquivalenceClass() {
        DPLEquivalenceClass ec = Common_DatapoolFactory.eINSTANCE.createDPLEquivalenceClass();
        return ec;
    }

    public org.eclipse.hyades.edit.datapool.IDatapoolVariable constructVariable() {
        DPLVariable var = Common_DatapoolFactory.eINSTANCE.createDPLVariable();
        return var;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

