/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.MessageProcessingException;

public abstract class ExecutionComponentImpl
implements IExecutionComponent {
    private static final String VERSION = "1.0";
    protected String name;
    protected String id;
    protected String type;
    protected String version;
    protected int state;
    protected INode node;
    protected Vector stateChangeListeners = new Vector();
    protected ArrayList children = new ArrayList();
    protected IExecutionComponent parent;

    public void init() {
        this.version = VERSION;
        this.state = 1;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public IExecutionComponent getParent() {
        return this.parent;
    }

    public void setParent(IExecutionComponent iExecutionComponent) {
        this.parent = iExecutionComponent;
    }

    public IExecutionComponent[] getChildren() {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            IExecutionComponent[] iExecutionComponentArray = new IExecutionComponent[this.children.size()];
            Iterator iterator = ((AbstractList)this.children).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iExecutionComponentArray[n] = (IExecutionComponent)iterator.next();
                ++n;
            }
            IExecutionComponent[] iExecutionComponentArray2 = iExecutionComponentArray;
            return iExecutionComponentArray2;
        }
    }

    public IExecutionComponent getChildById(String string) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.children).iterator();
            while (iterator.hasNext()) {
                IExecutionComponent iExecutionComponent = (IExecutionComponent)iterator.next();
                if (!iExecutionComponent.getId().equals(string)) continue;
                IExecutionComponent iExecutionComponent2 = iExecutionComponent;
                return iExecutionComponent2;
            }
        }
        return null;
    }

    public IExecutionComponent getChildByName(String string) {
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            Iterator iterator = ((AbstractList)this.children).iterator();
            while (iterator.hasNext()) {
                IExecutionComponent iExecutionComponent = (IExecutionComponent)iterator.next();
                if (!iExecutionComponent.getName().equals(string)) continue;
                IExecutionComponent iExecutionComponent2 = iExecutionComponent;
                return iExecutionComponent2;
            }
        }
        return null;
    }

    public void addChild(IExecutionComponent iExecutionComponent) {
        this.children.add(iExecutionComponent);
        iExecutionComponent.setParent(this);
    }

    public INode getNode() {
        return this.node;
    }

    public int getState() {
        return this.state;
    }

    public void addExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener iExecutionComponentStateChangeListener) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.stateChangeListeners.add(iExecutionComponentStateChangeListener);
        }
    }

    public void removeExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener iExecutionComponentStateChangeListener) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.stateChangeListeners.remove(iExecutionComponentStateChangeListener);
        }
    }

    public void fireStateChangeEvent(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
        Vector vector = this.stateChangeListeners;
        synchronized (vector) {
            this.state = executionComponentStateChangeEvent.getState();
            Enumeration enumeration = this.stateChangeListeners.elements();
            while (enumeration.hasMoreElements()) {
                IExecutionComponentStateChangeListener iExecutionComponentStateChangeListener = (IExecutionComponentStateChangeListener)enumeration.nextElement();
                iExecutionComponentStateChangeListener.stateChanged(executionComponentStateChangeEvent);
            }
        }
    }

    public void handleMessage(IControlMessage iControlMessage) throws MessageProcessingException {
        throw new MessageProcessingException("No handler for this message");
    }

    public void sendMessage(IControlMessage iControlMessage) throws MessageDeliveryException {
        throw new MessageDeliveryException("Impl class does not send messages.  This must be handled by the stubs/skeletons");
    }
}

