/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationFailedCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.ContextMapper;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class ConnectionImpl
implements Connection {
    protected Socket _socket;
    protected Node _node;
    protected int _port;
    private static long _context = 1L;
    private ContextMapper _contextMapper = null;
    private CommandHandler _cmdHandler = null;
    private boolean _isComplete = false;
    private Vector _listeners = new Vector();
    private Vector _authenticationlisteners = new Vector();
    private Object _connectionLock = new Object();
    private Object _loginLock = new Object();
    private boolean _isInitialized = false;
    private SecureConnectionRequiredException _secureConnectionRequiredException;
    private LoginFailedException _loginFailed;
    private boolean _loginPending = false;

    public void connect(Node node, int n) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = n;
        int n2 = 0;
        InetAddress[] inetAddressArray = node.getAllInetAddresses();
        while (true) {
            try {
                this._socket = new Socket(inetAddressArray[n2], n);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                if (++n2 != inetAddressArray.length) continue;
                throw iOException;
                if (n2 < inetAddressArray.length) continue;
            }
            break;
        }
        this._node = node;
        this.init();
    }

    protected void init() throws IOException, SecureConnectionRequiredException, LoginFailedException {
        try {
            this._socket.setSoTimeout(1000);
            this._socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this._contextMapper = new ContextMapper();
        final ConnectionImpl connectionImpl = this;
        Node node = this._node;
        this._cmdHandler = new CommandHandler(){

            public void incommingCommand(Node node, CommandElement commandElement) {
                long l = commandElement.getContext();
                switch ((int)commandElement.getTag()) {
                    case 4: {
                        ConnectionImpl.this._secureConnectionRequiredException = new SecureConnectionRequiredException((ServerSecurityInfoCommand)commandElement);
                        ConnectionImpl.this.disconnect();
                        break;
                    }
                    case 2: {
                        Vector vector = ConnectionImpl.this._authenticationlisteners;
                        synchronized (vector) {
                            AuthenticationFailedCommand authenticationFailedCommand = (AuthenticationFailedCommand)commandElement;
                            if (node.getUser() != null && authenticationFailedCommand.getTicket() == 0L) {
                                try {
                                    ConnectionImpl.this._loginPending = true;
                                    node.getUser().login(connectionImpl);
                                    break;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            Enumeration enumeration = ConnectionImpl.this._authenticationlisteners.elements();
                            while (enumeration.hasMoreElements()) {
                                if (authenticationFailedCommand.getTicket() == 0L) {
                                    ((AuthenticationListener)enumeration.nextElement()).authenticationRequired(connectionImpl);
                                    continue;
                                }
                                ((AuthenticationListener)enumeration.nextElement()).authenticationFailed(connectionImpl);
                            }
                            Object object = ConnectionImpl.this._loginLock;
                            synchronized (object) {
                                Object object2 = ConnectionImpl.this._connectionLock;
                                synchronized (object2) {
                                    ConnectionImpl.this._loginFailed = new LoginFailedException(ConnectionImpl.this.getPort());
                                    ConnectionImpl.this._loginPending = false;
                                    ConnectionImpl.this.disconnect();
                                    ConnectionImpl.this._connectionLock.notifyAll();
                                    ConnectionImpl.this._loginLock.notifyAll();
                                }
                            }
                        }
                    }
                    case 3: {
                        Object object;
                        Vector vector = ConnectionImpl.this._authenticationlisteners;
                        synchronized (vector) {
                            object = ConnectionImpl.this._authenticationlisteners.elements();
                            while (object.hasMoreElements()) {
                                ((AuthenticationListener)object.nextElement()).authenticationSuccessful(connectionImpl);
                            }
                        }
                        object = ConnectionImpl.this._loginLock;
                        synchronized (object) {
                            Object object3 = ConnectionImpl.this._connectionLock;
                            synchronized (object3) {
                                ConnectionImpl.this._loginPending = false;
                                ConnectionImpl.this._connectionLock.notifyAll();
                                ConnectionImpl.this._loginLock.notifyAll();
                            }
                        }
                    }
                    default: {
                        CommandHandler commandHandler = ConnectionImpl.this._contextMapper.getHandler(l);
                        if (commandHandler == null) break;
                        commandHandler.incommingCommand(ConnectionImpl.this._node, commandElement);
                    }
                }
            }
        };
        Object object = this._connectionLock;
        synchronized (object) {
            SocketReaderThread socketReaderThread = new SocketReaderThread();
            if (this._node.getUser() == null) {
                socketReaderThread.setName(this._node.getName() + "_connection");
            } else {
                socketReaderThread.setName(this._node.getName() + "_" + this._node.getUser().getName() + "_connection");
            }
            socketReaderThread.setDaemon(true);
            socketReaderThread.start();
            try {
                this._connectionLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._isInitialized = true;
            if (this._secureConnectionRequiredException != null) {
                SecureConnectionRequiredException secureConnectionRequiredException = this._secureConnectionRequiredException;
                this._secureConnectionRequiredException = null;
                this._loginPending = false;
                throw secureConnectionRequiredException;
            }
            Object object2 = this._loginLock;
            synchronized (object2) {
                if (this._loginPending) {
                    try {
                        this._loginLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this._loginFailed != null) {
                LoginFailedException loginFailedException = this._loginFailed;
                this._loginFailed = null;
                this._loginPending = false;
                throw loginFailedException;
            }
            if (this._isComplete) {
                throw new IOException();
            }
        }
    }

    public void sendMessage(ControlMessage controlMessage, CommandHandler commandHandler) throws IOException {
        int n = controlMessage.getSize();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < controlMessage.getCommandCount()) {
            controlMessage.getCommand(n2).setContext(_context++);
            this._contextMapper.addContext(controlMessage.getCommand(n2).getContext(), commandHandler);
            ++n2;
        }
        controlMessage.writeToBuffer(byArray, 0);
        OutputStream outputStream = this._socket.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
    }

    public void disconnect() {
        Object object = this._connectionLock;
        synchronized (object) {
            if (!this._isComplete) {
                this._isComplete = true;
                this._connectionLock.notifyAll();
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this._node instanceof NodeImpl) {
                    ((NodeImpl)this._node).setSecurityParameters(null);
                }
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ConnectionListener connectionListener = (ConnectionListener)enumeration.nextElement();
                        connectionListener.connectionClosed(this);
                    }
                }
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public boolean isActive() {
        if (this._isInitialized) {
            return !this._isComplete;
        }
        return false;
    }

    public int getPort() {
        return this._port;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(connectionListener)) {
                this._listeners.add(connectionListener);
            }
        }
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(connectionListener)) {
                this._listeners.remove(connectionListener);
            }
        }
    }

    public void addAuthenticationListener(AuthenticationListener authenticationListener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (!this._authenticationlisteners.contains(authenticationListener)) {
                this._authenticationlisteners.add(authenticationListener);
            }
        }
    }

    public void removeAuthenticationListener(AuthenticationListener authenticationListener) {
        Vector vector = this._authenticationlisteners;
        synchronized (vector) {
            if (this._authenticationlisteners.contains(authenticationListener)) {
                this._authenticationlisteners.remove(authenticationListener);
            }
        }
    }

    protected int processControlMessage(byte[] byArray, int n, int n2) {
        if (this._cmdHandler != null) {
            ControlMessage controlMessage = new ControlMessage();
            int n3 = -1;
            try {
                n3 = controlMessage.readFromBuffer(byArray, n);
                if (n3 > n + n2) {
                    return -1;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return -1;
            }
            catch (Exception exception) {
                return -1;
            }
            if ((long)n3 == controlMessage.getLength() + (long)n) {
                int n4 = controlMessage.getCommandCount();
                int n5 = 0;
                while (n5 < n4) {
                    this._cmdHandler.incommingCommand(this._node, controlMessage.getCommand(n5));
                    ++n5;
                }
            }
            return n3;
        }
        return -1;
    }

    static /* synthetic */ boolean access$700(ConnectionImpl connectionImpl) {
        return connectionImpl._isComplete;
    }

    static /* synthetic */ boolean access$800(ConnectionImpl connectionImpl) {
        return connectionImpl._isInitialized;
    }

    class SocketReaderThread
    extends Thread
    implements Constants {
        SocketReaderThread() {
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = new byte[8096];
            var2_2 = 0;
            var4_3 = 0;
            while (!ConnectionImpl.access$700(ConnectionImpl.this)) {
                var3_4 = false;
                try {
                    var5_5 = ConnectionImpl.this._socket.getInputStream();
                    var6_7 = var5_5.read(var1_1, var2_2, var1_1.length - var2_2);
                    if (var6_7 == -1) break;
                    if (var2_2 > 0) {
                        var6_7 += var2_2;
                        var2_2 = 0;
                    }
                    var7_10 = new Message();
                    while (var2_2 < var6_7) {
                        var8_12 = 0;
                        try {
                            var8_12 = var7_10.readFromBuffer(var1_1, var2_2);
                            if (var8_12 > var6_7) {
                                var9_13 = var2_2;
                                var10_17 = 0;
                                while (var9_13 < var6_7) {
                                    var1_1[var10_17] = var1_1[var9_13];
                                    ++var9_13;
                                    ++var10_17;
                                }
                                var2_2 = var6_7 - var2_2;
                                var3_4 = true;
                                break;
                            }
                        }
                        catch (IndexOutOfBoundsException var9_14) {
                            var10_18 = var2_2;
                            var11_22 = 0;
                            ** while (var10_18 < var6_7)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var1_1[var11_22] = var1_1[var10_18];
                            ++var10_18;
                            ++var11_22;
                            continue;
                        }
lbl38:
                        // 1 sources

                        var2_2 = var6_7 - var2_2;
                        var3_4 = true;
                        break;
                        catch (Exception var10_19) {
                            break;
                        }
                        if (var7_10.getType() == 0L) continue;
                        var8_12 = ConnectionImpl.this.processControlMessage(var1_1, var2_2, var6_7);
                        if (var8_12 == -1) {
                            if (var2_2 > 0) {
                                var9_15 = var2_2;
                                var10_20 = 0;
                                while (var9_15 < var6_7) {
                                    var1_1[var10_20] = var1_1[var9_15];
                                    ++var9_15;
                                    ++var10_20;
                                }
                            } else if (var6_7 == var1_1.length) {
                                var9_16 = var1_1.length * 2;
                                var10_21 = new byte[var9_16];
                                System.arraycopy(var1_1, var2_2, var10_21, 0, var6_7 - var2_2);
                                var1_1 = var10_21;
                            }
                            var2_2 = var6_7 - var2_2;
                            var3_4 = true;
                            break;
                        }
                        var2_2 = var8_12;
                    }
                    if (var3_4) continue;
                    var2_2 = 0;
                }
                catch (InterruptedIOException var5_6) {
                    if (var4_3 > 6 && !ConnectionImpl.access$800(ConnectionImpl.this)) {
                        var6_8 = ConnectionImpl.access$400(ConnectionImpl.this);
                        synchronized (var6_8) {
                            ConnectionImpl.access$400(ConnectionImpl.this).notifyAll();
                        }
                    }
                    ++var4_3;
                }
                catch (SocketException var6_9) {
                    break;
                }
                catch (IOException var7_11) {
                    break;
                }
            }
            ConnectionImpl.this.disconnect();
        }
    }
}

