/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.collection.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class UserConsole {
    private PrintWriter bStdin = null;
    private InputStream stdout = null;
    private InputStream stderr = null;
    private InThread in = new InThread();
    private OutThread out = new OutThread();
    private ErrThread err = new ErrThread();

    public UserConsole() {
        this.in.setDaemon(true);
        this.out.setDaemon(true);
        this.err.setDaemon(true);
    }

    public void setStdin(OutputStream outputStream) {
        this.bStdin = new PrintWriter(new OutputStreamWriter(outputStream));
    }

    public void setStdout(InputStream inputStream) {
        this.stdout = inputStream;
    }

    public void setStderr(InputStream inputStream) {
        this.stderr = inputStream;
    }

    public void start() {
        this.in.start();
        this.out.start();
        this.err.start();
    }

    class ErrThread
    extends Thread {
        public ErrThread() {
            this.setName("stderr");
        }

        public void run() {
            if (UserConsole.this.stderr == null) {
                return;
            }
            try {
                int n;
                while ((n = UserConsole.this.stderr.read()) != -1) {
                    System.err.print((char)n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class OutThread
    extends Thread {
        public OutThread() {
            this.setName("stdout");
        }

        public void run() {
            if (UserConsole.this.stdout == null) {
                return;
            }
            try {
                int n;
                while ((n = UserConsole.this.stdout.read()) != -1) {
                    System.out.print((char)n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class InThread
    extends Thread {
        public InThread() {
            this.setName("stdin");
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            if (UserConsole.this.bStdin == null) {
                return;
            }
            try {
                while (true) {
                    String string = bufferedReader.readLine();
                    UserConsole.this.bStdin.println(string);
                    UserConsole.this.bStdin.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
    }
}

