/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.impl.Controller;
import org.eclipse.hyades.logging.adapter.internal.util.Paths;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class Adapter {
    private Controller rootController = null;
    private String contextFile = null;
    private String componentFile = null;

    public void setContextConfigPath(String string) {
        this.contextFile = Paths.getConfigFileName(string);
    }

    public void setComponentConfigPath(String string) {
        this.componentFile = Paths.getConfigFileName(string);
    }

    public void start(boolean bl, boolean bl2) throws AdapterException {
        this.rootController = new Controller();
        if (this.componentFile == null) {
            this.componentFile = Messages.getString("HyadesGADefaultComponentConfigurationsFile");
        }
        if (this.contextFile == null) {
            this.contextFile = Messages.getString("HyadesGADefaultContextConfigurationFile");
        }
        this.rootController.setContextConfigPath(this.contextFile);
        this.rootController.setComponentConfigPath(this.componentFile);
        this.rootController.prepareAdapter();
        if (!bl) {
            this.rootController.run();
        } else {
            Thread thread = new Thread(this.rootController);
            thread.setDaemon(bl2);
            thread.start();
        }
    }

    public void stop() {
        if (this.rootController != null) {
            this.rootController.stop();
        }
    }

    public static void main(String[] stringArray) {
        Adapter adapter = new Adapter();
        if (adapter.parseCommandLine(stringArray)) {
            try {
                adapter.start(false, false);
            }
            catch (AdapterException adapterException) {
                adapter.stop();
            }
        } else {
            System.out.println(Messages.getString("HyadesGACommand_line_usage"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCommandLine(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) return true;
        String string = Messages.getString("HyadesGA-cc");
        String string2 = Messages.getString("HyadesGA-ac");
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                if (++n >= stringArray.length || stringArray[n] == null) return false;
                this.setContextConfigPath(Paths.getConfigFileName(stringArray[n]));
            } else {
                if (!string2.equalsIgnoreCase(stringArray[n])) return false;
                if (++n >= stringArray.length || stringArray[n] == null) return false;
                this.setComponentConfigPath(Paths.getConfigFileName(stringArray[n]));
            }
            ++n;
        }
        return true;
    }
}

