/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.impl.Context;

public class BasicContext
extends Context {
    public boolean init() {
        super.init();
        return this.testRun();
    }

    private boolean testRun() {
        ISensor iSensor = (ISensor)this.getComponents()[0];
        Object[] objectArray = iSensor.testGetNext();
        try {
            this.testProcessMessages(objectArray, 1);
        }
        catch (AdapterInvalidConfig adapterInvalidConfig) {
            this.log(adapterInvalidConfig.toString(), (short)60);
            return false;
        }
        catch (Exception exception) {
            this.log(exception.toString(), (short)60);
            return false;
        }
        return true;
    }

    private void testProcessMessages(Object[] objectArray, int n) throws AdapterInvalidConfig {
        IComponent[] iComponentArray = this.getComponents();
        if (n < iComponentArray.length) {
            Object[] objectArray2 = ((IProcessUnit)iComponentArray[n]).testProcessEventItems(objectArray);
            ++n;
            if (objectArray2 != null && objectArray2[0] != null) {
                this.testProcessMessages(objectArray2, n);
            }
        }
    }

    public void run() {
        try {
            ISensor iSensor = (ISensor)this.getComponents()[0];
            try {
                while (!this.stopping) {
                    if (this.listener != null) {
                        try {
                            this.listener.preProcessEventItems(iSensor, null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    Object[] objectArray = iSensor.getNext();
                    if (this.listener != null) {
                        try {
                            this.listener.postProcessEventItems(iSensor, objectArray);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (objectArray == null) {
                        this.handleControledStop();
                        continue;
                    }
                    this.resetControledStop();
                    this.processMessages(objectArray, 1);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processMessages(Object[] objectArray, int n) {
        IComponent[] iComponentArray = this.getComponents();
        if (n > 0 && n < iComponentArray.length) {
            if (this.listener != null) {
                try {
                    this.listener.preProcessEventItems(iComponentArray[n], objectArray);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Object[] objectArray2 = ((IProcessUnit)iComponentArray[n]).processEventItems(objectArray);
            if (this.listener != null) {
                try {
                    this.listener.postProcessEventItems(iComponentArray[n], objectArray2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n;
            if (objectArray2 != null) {
                this.processMessages(objectArray2, n);
            }
        }
    }

    public void stop() {
        if (this.listener != null && !this.isHardStop()) {
            try {
                this.listener.preProcessEventItems(this.getComponents()[0], null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Object[] objectArray = ((ISensor)this.getComponents()[0]).flush();
        if (this.listener != null && !this.isHardStop()) {
            try {
                this.listener.postProcessEventItems(this.getComponents()[0], objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.flushMessages(objectArray, 1);
        super.stop();
    }

    private void flushMessages(Object[] objectArray, int n) {
        IComponent[] iComponentArray = this.getComponents();
        if (n > 0 && n < iComponentArray.length) {
            if (this.listener != null && !this.isHardStop()) {
                try {
                    this.listener.preProcessEventItems(iComponentArray[n], objectArray);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Object[] objectArray2 = ((IProcessUnit)iComponentArray[n]).flushEventItems(objectArray);
            if (this.listener != null && !this.isHardStop()) {
                try {
                    this.listener.postProcessEventItems(iComponentArray[n], objectArray2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n;
            if (objectArray2 != null) {
                this.processMessages(objectArray2, n);
            }
        }
    }
}

