/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Proto;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSEntryPoint;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class TOSInfo {
    protected Vector _entryPoints = null;
    protected Hashtable _oldThreadsByTOS = null;
    protected Hashtable _threadsByTOS = null;
    private static int dotCountMinor = 0;
    private static int dotCountMajor = 0;

    public TOSInfo(Hashtable hashtable) {
        this._oldThreadsByTOS = hashtable;
        this._threadsByTOS = new Hashtable();
        this.build();
    }

    public int tosCount() {
        return this._threadsByTOS.size();
    }

    public Hashtable getTosHT() {
        return this._threadsByTOS;
    }

    protected void build() {
        Enumeration enumeration = this._oldThreadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            Vector<TOSEntryPoint> vector = new Vector<TOSEntryPoint>();
            Vector vector2 = null;
            Vector<Proto> vector3 = new Vector<Proto>();
            String string = (String)enumeration.nextElement();
            vector2 = (Vector)this._oldThreadsByTOS.get(string);
            if (vector2.size() < 1) break;
            Thd thd = (Thd)vector2.elementAt(0);
            Proto proto = new Proto();
            proto._threads.add(thd);
            vector3.add(proto);
            int n2 = 1;
            while (n2 < vector2.size()) {
                n = 0;
                thd = (Thd)vector2.elementAt(n2);
                int n3 = 0;
                while (n3 < vector3.size()) {
                    proto = (Proto)vector3.elementAt(n3);
                    Thd thd2 = proto.getPrototype();
                    if (this.compareStack(thd, thd2)) {
                        proto._threads.add(thd);
                        n = 1;
                        break;
                    }
                    ++n3;
                }
                if (n == 0) {
                    proto = new Proto();
                    proto._threads.add(thd);
                    vector3.add(proto);
                }
                ++n2;
            }
            ++dotCountMinor;
            if (vector3.size() > 1) {
                n = 0;
                while (n < vector3.size() - 1) {
                    Proto proto2 = (Proto)vector3.elementAt(0);
                    int n4 = n + 1;
                    while (n4 < vector3.size()) {
                        this.mark();
                        Proto proto3 = (Proto)vector3.elementAt(n4);
                        int n5 = this.compareForStkSimilarity(proto2, proto3);
                        if (n5 > 1) {
                            TOSEntryPoint tOSEntryPoint = this.findEntryPoint(proto2, n5, vector);
                            if (tOSEntryPoint != null) {
                                tOSEntryPoint.addThreadsNoDups(proto2._threads);
                                tOSEntryPoint.addThreadsNoDups(proto3._threads);
                            } else {
                                StkEntry stkEntry = proto2.getPrototype().getStkEntry(n5);
                                if (stkEntry != null) {
                                    tOSEntryPoint = new TOSEntryPoint(stkEntry);
                                    tOSEntryPoint.addThreadsNoDups(proto2._threads);
                                    tOSEntryPoint.addThreadsNoDups(proto3._threads);
                                    vector.add(tOSEntryPoint);
                                }
                            }
                        }
                        ++n4;
                    }
                    ++n;
                }
            }
            if (vector == null || vector.size() <= 0) continue;
            this._threadsByTOS.put(string, vector);
        }
    }

    private void mark() {
        if (dotCountMinor++ == 100) {
            dotCountMinor = 0;
            ++dotCountMajor;
        }
        if (dotCountMajor == 50) {
            dotCountMajor = 0;
        }
    }

    protected int compareForStkSimilarity(Proto proto, Proto proto2) {
        Thd thd = proto.getPrototype();
        Thd thd2 = proto2.getPrototype();
        Object var5_5 = null;
        Object var6_6 = null;
        int n = 0;
        while (n < thd.getStkSize() && n < thd2.getStkSize()) {
            if (!thd.getStkEntry(n).getFQName().equals(thd2.getStkEntry(n).getFQName())) break;
            ++n;
        }
        return n;
    }

    protected TOSEntryPoint findEntryPoint(Proto proto, int n, Vector vector) {
        TOSEntryPoint tOSEntryPoint = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            StkEntry stkEntry;
            String string;
            TOSEntryPoint tOSEntryPoint2 = (TOSEntryPoint)vector.elementAt(n2);
            if (tOSEntryPoint2 != null && n < proto.getPrototype().getStkSize() && (string = tOSEntryPoint2.getName()).equals((stkEntry = proto.getPrototype().getStkEntry(n)).getFQName())) {
                Thd thd = (Thd)tOSEntryPoint2._threads.elementAt(0);
                Thd thd2 = proto.getPrototype();
                tOSEntryPoint = tOSEntryPoint2;
                int n3 = 0;
                while (n3 <= n) {
                    if (!thd.getStkEntry(n).getFQName().equals(thd2.getStkEntry(n).getFQName())) {
                        tOSEntryPoint = null;
                        break;
                    }
                    ++n3;
                }
            }
            if (tOSEntryPoint != null) break;
            ++n2;
        }
        return tOSEntryPoint;
    }

    protected boolean compareStack(Thd thd, Thd thd2) {
        boolean bl = false;
        if (thd.getStkSize() == thd2.getStkSize()) {
            int n = 0;
            while (n < thd.getStkSize()) {
                if (!thd.getStkEntry(n).getFQName().equals(thd2.getStkEntry(n).getFQName())) break;
                ++n;
            }
        }
        return bl;
    }
}

