/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.invocation;

public abstract class MarshalData {
    protected Integer targetId;
    protected Class[] argTypes;
    protected String call;

    protected MarshalData(Integer n, Class[] classArray, String string) {
        this.targetId = n;
        this.argTypes = classArray;
        this.call = string;
    }

    private MarshalData() {
    }

    public Integer getTargetId() {
        return this.targetId;
    }

    public Class[] getArgTypes() {
        return this.argTypes;
    }

    public String getCall() {
        return this.call;
    }

    public boolean isForSameCallAs(MarshalData marshalData) {
        if (marshalData == null) {
            return false;
        }
        if (!this.targetId.equals(marshalData.targetId)) {
            return false;
        }
        if (!this.call.equals(marshalData.call)) {
            return false;
        }
        if (this.argTypes.length != marshalData.argTypes.length) {
            return false;
        }
        int n = 0;
        while (n < this.argTypes.length) {
            if (!this.argTypes[n].equals(marshalData.argTypes[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

