/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.formatters;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.IAvailableSituation;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IConfigureSituation;
import org.eclipse.hyades.logging.events.IConnectSituation;
import org.eclipse.hyades.logging.events.IContextDataElement;
import org.eclipse.hyades.logging.events.ICreateSituation;
import org.eclipse.hyades.logging.events.IDependencySituation;
import org.eclipse.hyades.logging.events.IDestroySituation;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IFeatureSituation;
import org.eclipse.hyades.logging.events.IMsgDataElement;
import org.eclipse.hyades.logging.events.IOtherSituation;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.IRequestSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.IStartSituation;
import org.eclipse.hyades.logging.events.IStopSituation;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.events.exceptions.UnsupportedVersionException;

public class CBEFormatter
extends ProcessUnit
implements IFormatter,
ICBEPropertyConstants {
    private static final String BUILTIN = "##BUILTIN";
    private static ISimpleEventFactory eventFactory = SimpleEventFactoryImpl.getInstance();
    private String localHostId = null;
    private String localHostIdFormat = null;
    private static final String HOST_ID_FORMAT_IPV4 = "IPV4";
    private static final String HOST_ID_FORMAT_IPV6 = "IPV6";
    private static final String NONE = "None";
    private static final String UNKNOWN_HOST = "Unknown Host";

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return this.processDirectedGraphs(objectArray);
    }

    private ICommonBaseEvent[] processDirectedGraphs(Object[] objectArray) {
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = ((List)objectArray[n]).iterator();
            ICommonBaseEvent iCommonBaseEvent = eventFactory.createCommonBaseEvent();
            while (iterator.hasNext()) {
                IDirectedGraph iDirectedGraph = (IDirectedGraph)iterator.next();
                List list = iDirectedGraph.getPath();
                try {
                    if (((String)list.get(0)).equals("CommonBaseEvent")) {
                        Object object;
                        Object object2;
                        String string;
                        if (((String)list.get(2)).equals("extensionName")) {
                            iCommonBaseEvent.setExtensionName((String)iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("localInstanceId")) {
                            string = (String)iDirectedGraph.getValue();
                            if (string.equals(BUILTIN)) {
                                string = this.getLocalHostId() + System.currentTimeMillis() + Integer.toString(objectArray[n].hashCode());
                            }
                            iCommonBaseEvent.setLocalInstanceId(string);
                            continue;
                        }
                        if (((String)list.get(2)).equals("globalInstanceId")) {
                            string = (String)iDirectedGraph.getValue();
                            if (string.equals(BUILTIN)) {
                                string = new Guid().toString();
                            }
                            iCommonBaseEvent.setGlobalInstanceId(string);
                            continue;
                        }
                        if (((String)list.get(2)).equals("creationTime")) {
                            try {
                                string = (String)iDirectedGraph.getValue();
                                iCommonBaseEvent.setCreationTime(string);
                                continue;
                            }
                            catch (ClassCastException classCastException) {
                                object2 = (Long)iDirectedGraph.getValue();
                                iCommonBaseEvent.setCreationTime(((Long)object2).longValue());
                                continue;
                            }
                            catch (Exception exception) {
                                throw exception;
                            }
                        }
                        if (((String)list.get(2)).equals("severity")) {
                            iCommonBaseEvent.setSeverity(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("priority")) {
                            iCommonBaseEvent.setPriority(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("msg")) {
                            iCommonBaseEvent.setMsg((String)iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("repeatCount")) {
                            iCommonBaseEvent.setRepeatCount(Short.parseShort((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("elapsedTime")) {
                            iCommonBaseEvent.setElapsedTime(Long.parseLong((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("sequenceNumber")) {
                            iCommonBaseEvent.setSequenceNumber(Long.parseLong((String)iDirectedGraph.getValue()));
                            continue;
                        }
                        if (((String)list.get(2)).equals("version")) {
                            try {
                                iCommonBaseEvent.setPreferredVersion((String)iDirectedGraph.getValue());
                            }
                            catch (UnsupportedVersionException unsupportedVersionException) {}
                            continue;
                        }
                        if (((String)list.get(2)).equals("otherData")) {
                            iCommonBaseEvent.setOtherData((String[])iDirectedGraph.getValue());
                            continue;
                        }
                        if (((String)list.get(2)).equals("msgDataElement")) {
                            string = iCommonBaseEvent.getMsgDataElement();
                            if (string == null) {
                                string = eventFactory.createMsgDataElement();
                                iCommonBaseEvent.setMsgDataElement((IMsgDataElement)string);
                            }
                            if (((String)list.get(4)).equals("msgId")) {
                                string.setMsgId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgIdType")) {
                                string.setMsgIdType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogId")) {
                                string.setMsgCatalogId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogTokens")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (object2 == null || ((String)object2).length() <= 0) continue;
                                string.addMsgCatalogTokenAsString((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalogType")) {
                                string.setMsgCatalogType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgCatalog")) {
                                string.setMsgCatalog((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("msgLocale")) {
                                string.setMsgLocale((String)iDirectedGraph.getValue());
                                continue;
                            }
                            this.log(Messages.getString("HyadesGA_CBE_Formatter_MsgDataElement_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                            continue;
                        }
                        if (((String)list.get(2)).equals("contextDataElements")) {
                            string = (String)list.get(2) + (String)list.get(3);
                            object2 = (IContextDataElement)hashMap.get(string);
                            if (object2 == null) {
                                object2 = eventFactory.createContextDataElement();
                                iCommonBaseEvent.addContextDataElement((IContextDataElement)object2);
                                hashMap.put(string, object2);
                            }
                            if (((String)list.get(4)).equals("contextId")) {
                                if (object2.getContextValue() != null) {
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_Warning", this.getUniqueID(), (String)list.get(4), "contextValue"), (short)30);
                                    continue;
                                }
                                object2.setContextId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("type")) {
                                object2.setType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("name")) {
                                object2.setName((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("contextValue")) {
                                if (object2.getContextId() != null) {
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_Warning", this.getUniqueID(), (String)list.get(4), "contextId"), (short)30);
                                    continue;
                                }
                                object2.setContextValue((String)iDirectedGraph.getValue());
                                continue;
                            }
                            this.log(Messages.getString("HyadesGA_CBE_Formatter_ContextDataElement_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                            continue;
                        }
                        if (((String)list.get(2)).equals("reporterComponentId") || ((String)list.get(2)).equals("sourceComponentId")) {
                            if (((String)list.get(2)).equals("reporterComponentId")) {
                                string = iCommonBaseEvent.getReporterComponentId();
                                if (string == null) {
                                    string = eventFactory.createComponentIdentification();
                                    iCommonBaseEvent.setReporterComponentId((IComponentIdentification)string);
                                }
                            } else {
                                string = iCommonBaseEvent.getSourceComponentId();
                                if (string == null) {
                                    string = eventFactory.createComponentIdentification();
                                    iCommonBaseEvent.setSourceComponentId((IComponentIdentification)string);
                                }
                            }
                            if (((String)list.get(4)).equals("location")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (((String)object2).equals(BUILTIN)) {
                                    object2 = this.getLocalHostId();
                                }
                                string.setLocation((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("locationType")) {
                                object2 = (String)iDirectedGraph.getValue();
                                if (((String)object2).equals(BUILTIN)) {
                                    object2 = this.getLocalHostIdFormat();
                                }
                                string.setLocationType((String)object2);
                                continue;
                            }
                            if (((String)list.get(4)).equals("application")) {
                                string.setApplication((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("executionEnvironment")) {
                                string.setExecutionEnvironment((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("component")) {
                                string.setComponent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("subComponent")) {
                                string.setSubComponent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("componentIdType")) {
                                string.setComponentIdType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("componentType")) {
                                string.setComponentType((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("instanceId")) {
                                string.setInstanceId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("processId")) {
                                string.setProcessId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("threadId")) {
                                string.setThreadId((String)iDirectedGraph.getValue());
                                continue;
                            }
                            this.log(Messages.getString("HyadesGA_CBE_Formatter_ComponentIdentification_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                            continue;
                        }
                        if (((String)list.get(2)).equals("situation")) {
                            string = iCommonBaseEvent.getSituation();
                            if (string == null) {
                                string = eventFactory.createSituation();
                                iCommonBaseEvent.setSituation((ISituation)string);
                            }
                            if (((String)list.get(4)).equals("categoryName")) {
                                string.setCategoryName((String)iDirectedGraph.getValue());
                                continue;
                            }
                            if (((String)list.get(4)).equals("situationType")) {
                                if (((String)list.get(6)).equals("AvailableSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createAvailableSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IAvailableSituation) {
                                        object2 = (IAvailableSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("operationDisposition")) {
                                        object2.setOperationDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("processingDisposition")) {
                                        object2.setProcessingDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("availabilityDisposition")) {
                                        object2.setAvailabilityDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_AvailableSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("RequestSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createRequestSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IRequestSituation) {
                                        object2 = (IRequestSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_RequestSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("StartSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createStartSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IStartSituation) {
                                        object2 = (IStartSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_StartSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("StopSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createStopSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IStopSituation) {
                                        object2 = (IStopSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationQualifier")) {
                                        object2.setSituationQualifier((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_StopSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ConnectSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createConnectSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IConnectSituation) {
                                        object2 = (IConnectSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("situationDisposition")) {
                                        object2.setSituationDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_ConnectSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ConfigureSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createConfigureSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IConfigureSituation) {
                                        object2 = (IConfigureSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_ConfigureSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("CreateSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createCreateSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof ICreateSituation) {
                                        object2 = (ICreateSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_CreateSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("DestroySituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createDestroySituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IDestroySituation) {
                                        object2 = (IDestroySituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("successDisposition")) {
                                        object2.setSuccessDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_CreateSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("ReportSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createReportSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IReportSituation) {
                                        object2 = (IReportSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("reportCategory")) {
                                        object2.setReportCategory((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_ReportSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("FeatureSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createFeatureSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IFeatureSituation) {
                                        object2 = (IFeatureSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("featureDisposition")) {
                                        object2.setFeatureDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_FeatureSituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("DependencySituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createDependencySituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IDependencySituation) {
                                        object2 = (IDependencySituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("dependencyDisposition")) {
                                        object2.setDependencyDisposition((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_DependencySituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                if (((String)list.get(6)).equals("OtherSituation")) {
                                    object2 = null;
                                    object = string.getSituationType();
                                    if (object == null) {
                                        object2 = eventFactory.createOtherSituation();
                                        string.setSituationType((ISituationType)object2);
                                    } else if (object instanceof IOtherSituation) {
                                        object2 = (IOtherSituation)object;
                                    }
                                    if (object2 == null) continue;
                                    if (((String)list.get(8)).equals("reasoningScope")) {
                                        object2.setReasoningScope((String)iDirectedGraph.getValue());
                                        continue;
                                    }
                                    if (((String)list.get(8)).equals("anyData")) {
                                        object2.setAnyData((String[])iDirectedGraph.getValue());
                                        continue;
                                    }
                                    this.log(Messages.getString("HyadesGA_CBE_Formatter_DependencySituation_Warning", this.getUniqueID(), (String)list.get(8)), (short)30);
                                    continue;
                                }
                                this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_SituationType_Warning", this.getUniqueID(), (String)list.get(6)), (short)30);
                                continue;
                            }
                            this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_Situation_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                            continue;
                        }
                        if (((String)list.get(2)).startsWith("associatedEvents")) {
                            string = (String)list.get(2) + (String)list.get(3);
                            object2 = (IAssociatedEvent)hashMap.get(string);
                            if (object2 == null) {
                                object2 = eventFactory.createAssociatedEvent();
                                iCommonBaseEvent.addAssociatedEvent((IAssociatedEvent)object2);
                                hashMap.put(string, object2);
                            }
                            if (((String)list.get(4)).equals("associationEngine")) {
                                this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                                continue;
                            }
                            if (((String)list.get(4)).equals("associationEngineInfo")) {
                                object = object2.getAssociationEngineInfo();
                                if (object == null) {
                                    object = eventFactory.createAssociationEngine();
                                    object2.setAssociationEngineInfo((IAssociationEngine)object);
                                }
                                if (((String)list.get(6)).equals("id")) {
                                    object.setId((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                if (((String)list.get(6)).equals("name")) {
                                    object.setName((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                if (((String)list.get(6)).equals("type")) {
                                    object.setType((String)iDirectedGraph.getValue());
                                    continue;
                                }
                                this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_AssociationEngine_Warning", this.getUniqueID(), (String)list.get(6)), (short)30);
                                continue;
                            }
                            if (((String)list.get(4)).equals("resolvedEvent")) {
                                object2.addResolvedEvent((String)iDirectedGraph.getValue());
                                continue;
                            }
                            this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_Warning", this.getUniqueID(), (String)list.get(4)), (short)30);
                            continue;
                        }
                        if (((String)list.get(2)).startsWith("extendedDataElements")) {
                            string = (String)list.get(2) + (String)list.get(3);
                            object2 = (IExtendedDataElement)hashMap.get(string);
                            if (object2 == null) {
                                object2 = eventFactory.createExtendedDataElement();
                                iCommonBaseEvent.addExtendedDataElement((IExtendedDataElement)object2);
                                hashMap.put(string, object2);
                            }
                            object = (String)list.get(4);
                            int n2 = 4;
                            while (object != null) {
                                Object object3;
                                if (((String)object).equals("name")) {
                                    object2.setName((String)iDirectedGraph.getValue());
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("type")) {
                                    object2.setType((String)iDirectedGraph.getValue());
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("values")) {
                                    object3 = new String[]{(String)iDirectedGraph.getValue()};
                                    object2.setValues(object3);
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("hexValue")) {
                                    if (object2.getValues() != null) {
                                        this.log(Messages.getString("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_Warning", this.getUniqueID(), (String)object, "values"), (short)30);
                                    } else {
                                        object2.setHexValues((char[])iDirectedGraph.getValue());
                                    }
                                    object = null;
                                    continue;
                                }
                                if (((String)object).equals("children")) {
                                    IExtendedDataElement iExtendedDataElement;
                                    object3 = (String)list.get(++n2);
                                    List list2 = object2.getChildDataElements();
                                    if (list2 == null) {
                                        iExtendedDataElement = eventFactory.createExtendedDataElement();
                                        iExtendedDataElement.setName((String)object3);
                                        object2.addChildDataElement(iExtendedDataElement);
                                        object2 = iExtendedDataElement;
                                    } else {
                                        iExtendedDataElement = null;
                                        int n3 = 0;
                                        while (n3 < list2.size()) {
                                            if (((IExtendedDataElement)list2.get(n3)).getName().equals(object3)) {
                                                iExtendedDataElement = (IExtendedDataElement)list2.get(n3);
                                            }
                                            ++n3;
                                        }
                                        if (iExtendedDataElement == null) {
                                            iExtendedDataElement = eventFactory.createExtendedDataElement();
                                            iExtendedDataElement.setName((String)object3);
                                            object2.addChildDataElement(iExtendedDataElement);
                                        }
                                        object2 = iExtendedDataElement;
                                    }
                                    object = (String)list.get(n2 += 2);
                                    continue;
                                }
                                this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_ExtendedDataElement_Warning", this.getUniqueID(), (String)object), (short)30);
                                object = null;
                            }
                            continue;
                        }
                        this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_CommmonBaseEvent_Warning", this.getUniqueID(), (String)list.get(2)), (short)30);
                        continue;
                    }
                    this.log(Messages.getString("HyadesGA_CBE_Formatter_Invalid_Property_Warning", this.getUniqueID(), (String)list.get(0)), (short)30);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(Messages.getString("HyadesGA_CBE_Formatter_Non_Numeric_Property_Warning", this.getUniqueID(), (String)list.get(2)), (short)30);
                }
                catch (Exception exception) {
                    this.log(Messages.getString("HyadesGA_CBE_Formatter_Exception_Warning", this.getUniqueID(), (String)list.get(2), exception.getMessage()), (short)30);
                }
            }
            iCommonBaseEventArray[n] = iCommonBaseEvent;
            ++n;
        }
        return iCommonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        return this.testProcessDirectedGraphs(objectArray);
    }

    private ICommonBaseEvent[] testProcessDirectedGraphs(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray[0] instanceof List)) {
            throw new AdapterInvalidConfig("This formatter will only accept arrays of Lists");
        }
        ICommonBaseEvent[] iCommonBaseEventArray = new ICommonBaseEvent[]{eventFactory.createCommonBaseEvent()};
        return iCommonBaseEventArray;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
    }

    private void getLocalHostInfo() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? HOST_ID_FORMAT_IPV6 : HOST_ID_FORMAT_IPV4;
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = NONE;
        }
    }

    private String getLocalHostId() {
        if (this.localHostId == null) {
            this.getLocalHostInfo();
        }
        return this.localHostId;
    }

    private String getLocalHostIdFormat() {
        if (this.localHostIdFormat == null) {
            this.getLocalHostInfo();
        }
        return this.localHostIdFormat;
    }
}

