/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class TimeParser {
    private String format = null;
    private SimpleDateFormat formatter = null;

    private void setFormat(String string) throws AdapterException {
        if (string != null && !string.equals(this.format)) {
            this.format = string.trim();
            try {
                this.formatter = new SimpleDateFormat(this.format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AdapterException(illegalArgumentException);
            }
        }
    }

    public TimeParser(String string) throws AdapterException {
        this.setFormat(string);
    }

    public long parse(String string) throws AdapterException {
        long l = 0L;
        try {
            Date date;
            if (this.formatter != null && this.format != null && (date = this.formatter.parse(string.trim())) != null) {
                l = date.getTime();
            }
        }
        catch (Exception exception) {
            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_TimeParser_Exception_Error", string.trim(), this.format), exception);
        }
        return l;
    }
}

