/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.ConsoleNotStartedException;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.DetailedAgentInfoCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.LaunchProcessCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessLaunchedCommand;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.Connection;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;

public class ProcessImpl
implements Process,
AgentListener,
ConnectionListener {
    protected String _name = null;
    protected String _exe = null;
    protected String _params = null;
    protected String _location = null;
    protected String _processId = null;
    protected String _UUID = null;
    protected Node _node = null;
    protected Console _console = null;
    protected boolean _isActive = false;
    protected boolean _isComplete = false;
    protected Vector _agents = new Vector(10);
    protected Vector _variables = new Vector(20);
    protected Vector _listeners = new Vector(10);
    private Object _launcherLock = new Object();
    private Object _eclipseLock = new Object();
    private boolean _requireEclipseLock = false;
    private boolean _noSuchAliasExceptionThrown = false;

    public ProcessImpl(Node node) {
        this._node = node;
    }

    public ProcessImpl(Node node, String executable) {
        this(node, executable, null);
    }

    public ProcessImpl(Node node, String executable, String parameters) {
        this._node = node;
        this._exe = executable;
        this._params = parameters;
        this._console = new Console();
    }

    public ProcessImpl(Node node, String executable, long pid) {
        this._node = node;
        this._exe = executable;
        this._processId = new Long(pid).toString();
        this._isActive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws ProcessActiveException, NotConnectedException, NoSuchApplicationException {
        Object object;
        if (this.isActive() || this._isComplete) {
            throw new ProcessActiveException();
        }
        ControlMessage message = new ControlMessage();
        LaunchProcessCommand command = new LaunchProcessCommand();
        command.setExe(this._exe);
        command.setArgs(this._params);
        command.setLocation(this._location);
        if (this._console == null) {
            this._console = new Console();
        }
        this._console.start();
        try {
            command.setConsole(this._console);
        }
        catch (ConsoleNotStartedException e) {
            // empty catch block
        }
        Enumeration enumeration = this._variables.elements();
        while (enumeration.hasMoreElements()) {
            Variable var = (Variable)enumeration.nextElement();
            command.addEnvironmentVariable(var.getName(), var.getValue());
        }
        enumeration = this._agents.elements();
        while (enumeration.hasMoreElements()) {
            Agent agent = (Agent)enumeration.nextElement();
            command.addAgent(agent.getName());
        }
        message.appendCommand(command);
        Connection connection = this._node.getConnection();
        Object object2 = this._launcherLock;
        synchronized (object2) {
            try {
                connection.addConnectionListener(this);
                this._requireEclipseLock = false;
                connection.sendMessage(message, new CommandHandler(){

                    public void incommingCommand(Node node, CommandElement command) {
                        ProcessImpl.this.handleCommand(command);
                    }
                });
                this._requireEclipseLock = true;
            }
            catch (IOException e) {
                throw new NotConnectedException();
            }
            try {
                this._launcherLock.wait(7000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this._noSuchAliasExceptionThrown) {
            this._noSuchAliasExceptionThrown = false;
            throw new NoSuchApplicationException();
        }
        try {
            object = this._listeners;
            synchronized (object) {
                enumeration = this._listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ProcessListener)enumeration.nextElement()).processLaunched(this);
                }
            }
        }
        finally {
            object = this._eclipseLock;
            synchronized (object) {
                this._eclipseLock.notify();
            }
            connection.removeConnectionListener(this);
            if (!connection.isActive()) {
                throw new NotConnectedException();
            }
            if (!this.isActive()) {
                this._console.close();
            }
        }
    }

    public void kill(long delay) throws InactiveProcessException, NotConnectedException {
        if (this._node == null) {
            throw new InactiveProcessException();
        }
        this._node.killProcess(this);
    }

    public void addAgent(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.addElement(agent);
        }
    }

    public Enumeration listAgents() {
        return ((Vector)this._agents.clone()).elements();
    }

    public void removeAllAgents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAgentsByType(String type) {
        Vector<Agent> results = new Vector<Agent>();
        Vector vector = this._agents;
        synchronized (vector) {
            Enumeration agents = this.listAgents();
            while (agents.hasMoreElements()) {
                Agent agent = (Agent)agents.nextElement();
                if (!agent.getType().equals(type)) continue;
                results.addElement(agent);
            }
        }
        return results.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agent getAgent(String name) {
        Vector vector = this._agents;
        synchronized (vector) {
            Enumeration agents = this.listAgents();
            while (agents.hasMoreElements()) {
                Agent agent = (Agent)agents.nextElement();
                if (!agent.getName().equals(name)) continue;
                return agent;
            }
        }
        return null;
    }

    public Enumeration getEnvironment() {
        return this._variables.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener listener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(listener)) {
                this._listeners.remove(listener);
            }
        }
    }

    public Node getNode() {
        return this._node;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        int retryCount = 30;
        int delay = 1000;
        int i = 0;
        while (this._UUID == null && i < retryCount) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        return this._UUID;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public Console getConsole() {
        if (this._console == null) {
            this._console = new Console();
        }
        return this._console;
    }

    public void addEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.add(variable);
    }

    public Variable getEnvironmentVariable(String name) {
        Enumeration enumeration = this.getEnvironment();
        while (enumeration.hasMoreElements()) {
            Variable var = (Variable)enumeration.nextElement();
            if (!var.getName().equals(name)) continue;
            return var;
        }
        return null;
    }

    public void removeEnvironmentVariable(Variable variable) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._variables.remove(variable);
    }

    public void setExecutable(String exe) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._exe = exe;
    }

    public String getExecutable() {
        return this._exe;
    }

    public void setParameters(String params) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._params = params;
    }

    public String getParameters() {
        return this._params;
    }

    public void setLocation(String location) throws ProcessActiveException {
        if (this._isActive) {
            throw new ProcessActiveException();
        }
        this._location = location;
    }

    public String getProcessId() throws InactiveProcessException {
        int retryCount = 30;
        int delay = 1000;
        int i = 0;
        while (this._processId == null && i < retryCount) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        if (this._processId == null) {
            throw new InactiveProcessException();
        }
        return this._processId;
    }

    public void agentActive(Agent agent) {
        if (!this._agents.contains(agent)) {
            this._agents.add(agent);
        }
    }

    public void agentInactive(Agent agent) {
    }

    public void error(Agent agent, String errorId, String errorMessage) {
    }

    public void handleCommand(Agent agent, CommandElement command) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection) {
        Object object = this._eclipseLock;
        synchronized (object) {
            Object object2 = this._launcherLock;
            synchronized (object2) {
                this._launcherLock.notify();
                if (!this._requireEclipseLock) {
                    return;
                }
            }
            try {
                this._eclipseLock.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public String getlocation() {
        return this._location;
    }

    public void setUUID(String uuid) {
        this._UUID = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCommand(CommandElement command) {
        switch ((int)command.getTag()) {
            case 32: {
                Object name;
                if (this._isActive) break;
                ProcessLaunchedCommand plc = (ProcessLaunchedCommand)command;
                this._processId = new Long(plc.getProcessId()).toString();
                this._UUID = plc.getProcessUUID();
                this._variables.removeAllElements();
                String[] vars = plc.getEnvironment();
                int i = 0;
                while (i < vars.length) {
                    int equalsOffset = vars[i].indexOf(61);
                    if (equalsOffset > 0) {
                        name = vars[i].substring(0, equalsOffset);
                        String value = vars[i].substring(equalsOffset + 1);
                        this._variables.addElement(new Variable((String)name, value));
                    }
                    ++i;
                }
                this._isActive = true;
                Object object = this._eclipseLock;
                synchronized (object) {
                    name = this._launcherLock;
                    synchronized (name) {
                        this._launcherLock.notify();
                        if (!this._requireEclipseLock) {
                            break;
                        }
                    }
                    try {
                        this._eclipseLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 35: 
            case 36: {
                DetailedAgentInfoCommand aac = (DetailedAgentInfoCommand)command;
                Vector vector = this._agents;
                synchronized (vector) {
                    Agent agent = null;
                    Enumeration enumeration = this._agents.elements();
                    while (enumeration.hasMoreElements()) {
                        Agent current = (Agent)enumeration.nextElement();
                        if (!current.getName().equals(aac.getAgentName())) continue;
                        agent = current;
                        break;
                    }
                    if (agent == null) {
                        agent = AgentFactory.createAgent(this, aac.getAgentName(), aac.getAgentType());
                        ((AgentImpl)agent).setUUID(aac.getAgentUUID());
                    }
                    try {
                        AgentImpl agentImpl = (AgentImpl)agent;
                        if (agent.getUUID() == null) {
                            agentImpl.setUUID(aac.getAgentUUID());
                        }
                        agentImpl.handleCommand(command);
                    }
                    catch (ClassCastException e) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 37: {
                ErrorCommand ec = (ErrorCommand)command;
                if (!ec.getErrorId().equals("RAC002")) break;
                this._noSuchAliasExceptionThrown = true;
                Object enumeration = this._launcherLock;
                synchronized (enumeration) {
                    this._launcherLock.notify();
                    break;
                }
            }
            case 41: {
                try {
                    if (this._console != null) {
                        this._console.getServerSocket().close();
                    }
                }
                catch (IOException e1) {
                }
                catch (ConsoleNotStartedException e1) {
                    // empty catch block
                }
                if (this._isComplete) break;
                this._isComplete = true;
                Vector e1 = this._listeners;
                synchronized (e1) {
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((ProcessListener)enumeration.nextElement()).processExited(this);
                    }
                    break;
                }
            }
            default: {
                if (!(command instanceof SimpleAgentInfoCommand)) break;
                Agent agent = this.getAgent(((SimpleAgentInfoCommand)command).getAgentName());
                try {
                    if (agent == null) break;
                    ((AgentImpl)agent).handleCommand(command);
                }
                catch (ClassCastException e) {}
                break;
            }
        }
    }
}

