/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;

public class StkEntry
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _method;
    public String _pkg;
    public String _module;
    public int _lineno;
    public boolean _isNative;

    public StkEntry(String method, String pkg, String module, int lineno, boolean isNative) {
        this._version = _curVersion;
        this._method = method;
        this._pkg = pkg;
        this._lineno = lineno;
        this._isNative = isNative;
        this._module = module;
    }

    public String format(int indent) {
        String sIndent = "";
        int i = 0;
        while (i < indent) {
            sIndent = sIndent + "   ";
            ++i;
        }
        String sRet = sIndent + "      " + this._pkg + "." + this._method + " " + TAUtils.getNLSValue("ta.string.in", "in") + " " + this._module + " " + TAUtils.getNLSValue("ta.string.native", "native") + "=" + this._isNative;
        return sRet;
    }

    public void print(int indent) {
        System.out.println(this.format(indent));
    }

    public String getFQName() {
        return this._pkg + "." + this._method;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._version);
        out.writeObject(this._method);
        out.writeObject(this._pkg);
        out.writeObject(this._module);
        out.writeInt(this._lineno);
        out.writeBoolean(this._isNative);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        this._method = (String)in.readObject();
        this._pkg = (String)in.readObject();
        this._module = (String)in.readObject();
        this._lineno = in.readInt();
        this._isNative = in.readBoolean();
    }

    public StkEntry() {
    }
}

