/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;

public class ExecutionEnvironmentImpl
extends ExecutionComponentImpl
implements IExecutionEnvironment {
    protected static ArrayList originalProcessEnvironment = new ArrayList();
    protected ArrayList processEnvironment = new ArrayList();
    private static boolean nativesAvailable;

    public void init() {
        if (originalProcessEnvironment.size() == 0) {
            IOrderedProperty[] tmpEnv = this.getNativeSystemEnvironment();
            int i = 0;
            while (i < tmpEnv.length) {
                try {
                    if (tmpEnv[i] == null) break;
                    originalProcessEnvironment.add((IOrderedProperty)((OrderedPropertyImpl)tmpEnv[i]).clone());
                }
                catch (CloneNotSupportedException e1) {
                    // empty catch block
                }
                ++i;
            }
        }
        int j = 0;
        while (j < originalProcessEnvironment.size()) {
            try {
                this.processEnvironment.add((IOrderedProperty)((OrderedPropertyImpl)originalProcessEnvironment.get(j)).clone());
            }
            catch (CloneNotSupportedException e1) {
                // empty catch block
            }
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty[] getEnv() throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            IOrderedProperty[] validEnv = new IOrderedProperty[this.processEnvironment.size()];
            int i = 0;
            while (i < validEnv.length) {
                try {
                    validEnv[i] = (IOrderedProperty)((OrderedPropertyImpl)this.processEnvironment.get(i)).clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                ++i;
            }
            return validEnv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty getEnvByName(String name) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iter = this.processEnvironment.iterator();
            int offset = 0;
            while (iter.hasNext()) {
                IOrderedProperty current = (IOrderedProperty)iter.next();
                if (current.getName().equalsIgnoreCase(name)) {
                    return current;
                }
                ++offset;
            }
        }
        return null;
    }

    public void setEnv(IOrderedProperty[] env) throws ExecutionComponentStateException {
        this.processEnvironment.clear();
        int i = 0;
        while (i < env.length) {
            this.processEnvironment.add(env[i]);
            ++i;
        }
    }

    public void addEnv(IOrderedProperty env) throws ExecutionComponentStateException {
        this.processEnvironment.add(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOrderedProperty removeProperty(String name) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iter = this.processEnvironment.iterator();
            int offset = 0;
            while (iter.hasNext()) {
                IOrderedProperty current = (IOrderedProperty)iter.next();
                if (current.getName().equalsIgnoreCase(name)) {
                    this.processEnvironment.remove(offset);
                    return current;
                }
                ++offset;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnv(IOrderedProperty env) throws ExecutionComponentStateException {
        ArrayList arrayList = this.processEnvironment;
        synchronized (arrayList) {
            Iterator iter = this.processEnvironment.iterator();
            int offset = 0;
            while (iter.hasNext()) {
                IOrderedProperty current = (IOrderedProperty)iter.next();
                if (current.getName().equalsIgnoreCase(env.getName())) {
                    this.processEnvironment.remove(offset);
                    this.processEnvironment.add(offset, env);
                    return;
                }
                ++offset;
            }
        }
        this.addEnv(env);
    }

    private IOrderedProperty[] getNativeSystemEnvironment() {
        if (nativesAvailable) {
            return (IOrderedProperty[])this.getNativeSystemEnvironment0();
        }
        return new IOrderedProperty[0];
    }

    private native Object[] getNativeSystemEnvironment0();

    static {
        try {
            System.loadLibrary("hclaunch");
            nativesAvailable = true;
        }
        catch (Throwable e) {
            nativesAvailable = false;
        }
    }
}

