/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.util.HyadesResourceRegistryReader;
import org.eclipse.hyades.loaders.util.IHyadesResourceFactory;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;

public class HyadesResourceExtensions
extends HashMap {
    private static HyadesResourceExtensions instance;
    private IHyadesResourceFactory defaultHyadesResourceFactory;
    private Properties defaultProperties = new Properties();

    public static HyadesResourceExtensions getInstance() {
        block3: {
            if (instance != null) break block3;
            instance = new HyadesResourceExtensions();
            new HyadesResourceRegistryReader().readRegistry();
            try {
                Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
                Iterator iter = instance.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry element = iter.next();
                    IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)element.getValue();
                    if (HyadesResourceExtensions.instance.defaultHyadesResourceFactory != null || !preferences.getString("largeResourceSupportDBType").equals(hyadesResourceFactory.getStoreType((String)element.getKey()))) continue;
                    HyadesResourceExtensions.instance.defaultHyadesResourceFactory = hyadesResourceFactory;
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("username", preferences.getString("largeResourceSupportUsername"));
                    HyadesResourceExtensions.instance.defaultProperties.setProperty("password", preferences.getString("largeResourceSupportPassword"));
                }
            }
            catch (Exception e) {}
        }
        return instance;
    }

    public Resource createResource(URI uri) {
        IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createResource(uri, this.defaultProperties);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID) {
        IHyadesResourceFactory hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, owner, featureID, inverseFeatureID);
    }

    public EList createList(Class dataClass, InternalEObject owner, int featureID) {
        IHyadesResourceFactory hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(dataClass, owner, featureID);
    }

    public EList createList(InternalEObject owner, EStructuralFeature feature) {
        IHyadesResourceFactory hyadesResourceFactory = this.getHyadesResourceFactory(owner);
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createPagingList(owner, feature);
    }

    private IHyadesResourceFactory getHyadesResourceFactory(InternalEObject owner) {
        Resource resource = owner.eResource();
        if (resource == null) {
            if (this.defaultHyadesResourceFactory != null) {
                return this.defaultHyadesResourceFactory;
            }
            return null;
        }
        URI uri = resource.getURI();
        if (uri == null) {
            return null;
        }
        IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        return hyadesResourceFactory;
    }

    public Resource createResource(URI uri, Collection notLoaded) {
        IHyadesResourceFactory hyadesResourceFactory = (IHyadesResourceFactory)HyadesResourceExtensions.getInstance().get(LoadersUtils.getPostfix(uri));
        if (hyadesResourceFactory == null) {
            return null;
        }
        return hyadesResourceFactory.createResource(uri, this.defaultProperties, notLoaded);
    }

    public Properties getProperties() {
        return this.defaultProperties;
    }
}

