/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.util.Iterator;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LookupService;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.RegistryReader;

class LookupServiceRegistryReader
extends RegistryReader {
    static final String TAG_LOADER = "lookupService";
    static final String ATT_CLASS = "class";

    public LookupServiceRegistryReader() {
        super("lookup_service");
    }

    protected boolean readElement(HyadesConfigurationElement element) {
        if (element.getName().equals(TAG_LOADER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                try {
                    IHyadesPluginClassDescriptor classDescriptor = this.createPluginClassDescriptor(element, ATT_CLASS);
                    LookupService lookupService = (LookupService)classDescriptor.createInstance();
                    if (lookupService != null) {
                        Iterator iter = LookupServiceExtensions.getInstance().values().iterator();
                        while (iter.hasNext()) {
                            LookupService l = (LookupService)iter.next();
                            if (element.getClass() != lookupService.getClass()) continue;
                            lookupService = l;
                            break;
                        }
                        Iterator iter2 = lookupService.getSupportedTypes().iterator();
                        while (iter2.hasNext()) {
                            Class type = (Class)iter2.next();
                            LookupServiceExtensions.getInstance().put(type, lookupService);
                        }
                    } else {
                        this.logError(element, "Error when creating instance of lookup service: " + element.getAttribute(ATT_CLASS));
                    }
                }
                catch (Exception e) {
                    this.logError(element, e.getLocalizedMessage());
                }
                return true;
            }
        }
        return false;
    }
}

