/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.ActiveAgentListCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentActiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentAttachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetachedCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentDetailsCommand;
import org.eclipse.hyades.internal.execution.local.common.AgentInactiveCommand;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationFailedCommand;
import org.eclipse.hyades.internal.execution.local.common.AuthenticationSuccessfulCommand;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.ManageFileCommand;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessExitedCommand;
import org.eclipse.hyades.internal.execution.local.common.ProcessLaunchedCommand;
import org.eclipse.hyades.internal.execution.local.common.PropertyListCommand;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.RegisteredProcessListCommand;
import org.eclipse.hyades.internal.execution.local.common.ResourceLocation;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;

public class ControlMessage
extends Message {
    CommandElement[] _entries = null;
    long _length;
    protected RAString _key = new RAString("");

    public ControlMessage() {
        this._type = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendCommand(CommandElement command) {
        if (this._entries == null) {
            this._entries = new CommandElement[1];
            this._entries[0] = command;
            return;
        }
        CommandElement[] commandElementArray = this._entries;
        synchronized (this._entries) {
            CommandElement[] _oldElements = this._entries;
            this._entries = new CommandElement[_oldElements.length + 1];
            for (int i = 0; i < _oldElements.length; ++i) {
                this._entries[i] = _oldElements[i];
            }
            this._entries[_oldElements.length] = command;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public CommandElement getCommand(int offset) {
        return this._entries[offset];
    }

    public int getCommandCount() {
        return this._entries.length;
    }

    public RAString getKey() {
        return this._key;
    }

    public long getLength() {
        return this._length;
    }

    public int getSize() {
        int size = super.getSize();
        size += 4;
        size += this._key.getSize();
        size += 4;
        for (int i = 0; i < this._entries.length; ++i) {
            size += this._entries[i].getSize();
        }
        return size;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        this._length = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        current = ControlMessage.readRAStringFromBuffer(buffer, current, this._key);
        long count = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        this._entries = new CommandElement[(int)count];
        int i = 0;
        while ((long)i < count) {
            boolean success = true;
            long tag = Message.readRALongFromBuffer(buffer, current);
            current += 4;
            CommandElement command = null;
            switch ((int)tag) {
                case 2: {
                    command = new AuthenticationFailedCommand();
                    current = ((AuthenticationFailedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 3: {
                    command = new AuthenticationSuccessfulCommand();
                    current = ((AuthenticationSuccessfulCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 4: {
                    command = new ServerSecurityInfoCommand();
                    current = ((ServerSecurityInfoCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 32: {
                    command = new ProcessLaunchedCommand();
                    current = ((ProcessLaunchedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 41: {
                    command = new ProcessExitedCommand();
                    current = ((ProcessExitedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 33: {
                    command = new RegisteredProcessListCommand();
                    current = ((RegisteredProcessListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 34: {
                    command = new ActiveAgentListCommand();
                    current = ((ActiveAgentListCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 44: {
                    command = new AgentAttachedCommand();
                    current = ((AgentAttachedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 45: {
                    command = new AgentDetachedCommand();
                    current = ((AgentDetachedCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 35: {
                    command = new AgentActiveCommand();
                    current = ((AgentActiveCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 36: {
                    command = new AgentInactiveCommand();
                    current = ((AgentInactiveCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 40: {
                    command = new AgentDetailsCommand();
                    current = ((AgentDetailsCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 37: {
                    command = new ErrorCommand();
                    current = ((ErrorCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 26: {
                    command = new CustomCommand();
                    current = ((CustomCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 29: {
                    command = new BinaryCustomCommand();
                    current = ((BinaryCustomCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 98: {
                    command = new MonitorPeerRequestCommand();
                    current = ((MonitorPeerRequestCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 31: {
                    command = new ManageFileCommand();
                    current = ((ManageFileCommand)command).readFromBuffer(buffer, current);
                    break;
                }
                case 112: {
                    command = new ResourceLocation();
                    current = ((ResourceLocation)command).readFromBuffer(buffer, current);
                    break;
                }
                case 42: {
                    command = new PropertyListCommand();
                    current = ((PropertyListCommand)command).readFromBuffer(buffer, current);
                }
            }
            this._entries[i] = command;
            ++i;
        }
        return current;
    }

    public void setKey(RAString key) {
        this._key = key;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        this._length = this.getSize();
        current = Message.writeRALongToBuffer(buffer, current, this._length);
        current = ControlMessage.writeRAStringToBuffer(buffer, current, this._key);
        current = Message.writeRALongToBuffer(buffer, current, this._entries.length);
        for (int i = 0; i < this._entries.length; ++i) {
            current = this._entries[i].writeToBuffer(buffer, current);
        }
        return current;
    }
}

