/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.security.Provider;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureServerParameters;
import org.eclipse.hyades.internal.collection.framework.ConnectionHandlerImpl;

public class SecureServer
implements ISecureServerParameters {
    private int port;
    private boolean clientAuthenticationRequired;
    private String keystoreFile;
    private String keystorePassword;
    private Provider provider;
    private IKeystoreManager manager;
    IConnectionHandler connectionHandler;
    private String[] ciphers;
    private String[] protos;

    public int getPort() {
        return this.port;
    }

    public boolean clientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public Provider getSecurityProvider() {
        return this.provider;
    }

    public IConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = new ConnectionHandlerImpl();
        }
        return this.connectionHandler;
    }

    public String getKeystoreFileName() {
        return this.keystoreFile;
    }

    public String getKeystoreFilepassword() {
        return this.keystorePassword;
    }

    public IKeystoreManager getKeystoreManager() {
        return this.manager;
    }

    public String[] getEnabledCipherSuites() {
        return this.ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.protos;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClientAuthenticationRequired(boolean clientAuthenticationRequired) {
        this.clientAuthenticationRequired = clientAuthenticationRequired;
    }

    public void setKeystoreFile(String name) {
        this.keystoreFile = name;
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public void setSecurityProvider(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(name);
        this.provider = (Provider)clazz.newInstance();
    }

    public void setKeystoreManager(String name) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(name);
        this.manager = (IKeystoreManager)clazz.newInstance();
    }

    public void setCipherSuites(String[] ciphers) {
        if (ciphers != null) {
            for (int i = 0; i < ciphers.length; ++i) {
                ciphers[i] = ciphers[i].trim();
                System.out.println(ciphers[i]);
            }
        }
        this.ciphers = ciphers;
    }

    public void setProtocols(String[] protos) {
        if (protos != null) {
            for (int i = 0; i < protos.length; ++i) {
                protos[i] = protos[i].trim();
                System.out.println(protos[i]);
            }
        }
        this.protos = protos;
    }
}

