/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.collection.framework;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.DataChannelNotInitializedException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;

public class DCFlusherProcess {
    private static String fileName;
    private static String DCName;

    public static void main(String[] args) {
        DCFlusherProcess theReader = new DCFlusherProcess(args);
        DataChannelHelper dch = new DataChannelHelper();
        try {
            DataChannelImpl dc = dch.createDataChannel(DCName);
            dc.setFlushable();
            FileOutputStream fstream = new FileOutputStream(fileName);
            InputStream istrm = dc.getInputStream();
            byte[] inbytes = new byte[8096];
            int bytesRead = 0;
            try {
                while (true) {
                    if ((bytesRead = istrm.read(inbytes)) > 0) {
                        fstream.write(inbytes, 0, bytesRead);
                        continue;
                    }
                    if (bytesRead < 0) break;
                }
                istrm.close();
            }
            catch (IOException ioe) {
                System.out.println("IOException occurred tyring to read from file or write to data channe");
            }
            fstream.close();
        }
        catch (DataChannelCreationException e) {
            System.out.println("DCFlusherProcess:  could not create data channel with name " + DCName + "\n   Reason: " + e.getMessage());
        }
        catch (InvalidDataChannelAccessException e) {
            System.out.println("DCFlusherProcess:  Cannot read from this data channel");
        }
        catch (DataChannelNotInitializedException e) {
            System.out.println("DCFlusherProcess:  data channel is not initialized");
        }
        catch (FileNotFoundException e) {
            System.out.println("DCFlusherProcess:  could not open file " + fileName);
        }
        catch (IOException e) {
            System.out.println("DCFlusherProcess:  could not close file " + fileName);
        }
    }

    public DCFlusherProcess(String[] args) {
        System.out.println("DCFlusherProcess: Command line arguments, length=" + args.length);
        int i = 0;
        while (i < args.length) {
            System.out.println("\targs[" + i + "] = " + args[i]);
            ++i;
        }
        if (args.length == 2) {
            DCName = args[0];
            fileName = args[1];
        } else if (args.length == 1) {
            DCName = args[0];
            fileName = "c:\\temp\\dctest.out";
        } else {
            DCName = "shmchannel";
            fileName = "c:\\temp\\dctest.out";
        }
    }
}

