/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.loaders.util.HyadesConfigurationElement;
import org.eclipse.hyades.loaders.util.IHyadesPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.PlatformPluginClassDescriptor;
import org.eclipse.hyades.loaders.util.StandalonePluginClassDescriptor;
import org.eclipse.hyades.models.hierarchy.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RegistryReader {
    public static StandaloneConfiguration standaloneConfiguration;
    protected static int mode;
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String LOADER_PPID = "fragment_loader";
    protected static final String HANDLER_PPID = "fragment_handler";
    protected static final String LOADERS_FACTORY_PPID = "fragment_loaders_factory";
    protected static final String RESOURCE_LOADER_PPID = "resource_loader";
    protected static final String LOOKUP_SERVICE_PPID = "lookup_service";
    protected static final String HYADES_RESOURCE_EXTENSION_PPID = "hyades_resource_extension";
    protected static final String DATABASE_EXTENSIONS_PPID = "database_extensions";
    protected String thisPluginId = "org.eclipse.hyades.models.hierarchy";
    private List alreadyProcessedEclipseFolders;
    private String extensionPointID;

    public RegistryReader(String extensionPointID) {
        this.extensionPointID = extensionPointID;
    }

    public RegistryReader(String pluginId, String extensionPointID) {
        this.extensionPointID = extensionPointID;
        this.thisPluginId = pluginId;
    }

    public static synchronized boolean isPlatformMode() {
        if (mode == 0) {
            RegistryReader.setMode();
        }
        return mode == 1;
    }

    public static synchronized boolean isRCPMode() {
        String app;
        return RegistryReader.isPlatformMode() && (app = System.getProperty("eclipse.application")) != null && !app.equalsIgnoreCase("org.eclipse.ui.ide.workbench");
    }

    public IHyadesPluginClassDescriptor createPluginClassDescriptor(HyadesConfigurationElement element, String attribute) {
        if (RegistryReader.isPlatformMode()) {
            return new PlatformPluginClassDescriptor((IConfigurationElement)element.getElement(), attribute);
        }
        return new StandalonePluginClassDescriptor((Node)element.getElement(), attribute);
    }

    public void readRegistry() {
        if (RegistryReader.isPlatformMode()) {
            this.platformReadRegistry();
        } else {
            this.standaloneReadRegistry();
        }
    }

    protected void logError(HyadesConfigurationElement element, String text) {
        LoadersUtils.log("Plugin " + element.getDeclaringExtensionName() + ", extension " + element.getAttribute("class") + "\n" + text);
    }

    protected void logMissingAttribute(HyadesConfigurationElement element, String attributeName) {
        this.logError(element, "The required attribute '" + attributeName + "' not defined");
    }

    protected abstract boolean readElement(HyadesConfigurationElement var1);

    private static void setMode() {
        try {
            Class<?> resourcePlugin = Class.forName("org.eclipse.core.resources.ResourcesPlugin");
            Method getWorkspace = resourcePlugin.getMethod("getWorkspace", null);
            Object workspace = getWorkspace.invoke(null, null);
            Method getRoot = workspace.getClass().getMethod("getRoot", null);
            Object root = getRoot.invoke(workspace, null);
            mode = root != null ? 1 : 2;
        }
        catch (ClassNotFoundException e) {
            mode = 2;
        }
        catch (SecurityException e) {
            mode = 2;
        }
        catch (NoSuchMethodException e) {
            mode = 2;
        }
        catch (IllegalArgumentException e) {
            mode = 2;
        }
        catch (IllegalAccessException e) {
            mode = 2;
        }
        catch (InvocationTargetException e) {
            mode = 2;
        }
        catch (NullPointerException e) {
            mode = 2;
        }
    }

    private void addPackageExtensionPoints() {
        Iterator iter = standaloneConfiguration.getExtensionsList().iterator();
        while (iter.hasNext()) {
            HyadesConfigurationElement element = (HyadesConfigurationElement)iter.next();
            if (!element.getDeclaringExtensionName().equals("org.eclipse.emf.ecore.generated_package")) continue;
            try {
                String emfPackageClassName = element.getAttribute("class");
                if (standaloneConfiguration.getEmfPackageClassesList().contains(emfPackageClassName)) continue;
                standaloneConfiguration.getEmfPackageClassesList().add(emfPackageClassName);
            }
            catch (RuntimeException e) {
                LoadersUtils.log(e);
            }
        }
    }

    private void internalReadElement(HyadesConfigurationElement element) {
        boolean recognized = this.readElement(element);
        if (recognized) {
            HyadesConfigurationElement[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.internalReadElement(children[i]);
                ++i;
            }
        } else {
            this.logError(element, "Error processing extension: " + element.getDeclaringExtensionName());
        }
    }

    private void platformReadRegistry() {
        IExtensionPoint point = Platform.getPluginRegistry().getExtensionPoint(this.thisPluginId, this.extensionPointID);
        if (point != null) {
            IConfigurationElement[] elements = point.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                this.internalReadElement(new HyadesConfigurationElement(elements[i]));
                ++i;
            }
        }
    }

    private void processEMFpackages() {
        this.addPackageExtensionPoints();
        Iterator iter = standaloneConfiguration.getEmfPackageClassesList().iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            try {
                Class<?> clazz = Class.forName(element);
                try {
                    Field field = clazz.getField("eINSTANCE");
                    field.get(null);
                }
                catch (NoSuchFieldException e1) {
                    Method method = clazz.getMethod("init", null);
                    method.invoke(null, null);
                }
            }
            catch (ClassNotFoundException e) {
                LoadersUtils.log(e);
            }
            catch (SecurityException e) {
                LoadersUtils.log(e);
            }
            catch (NoSuchMethodException e) {
                LoadersUtils.log(e);
            }
            catch (IllegalArgumentException e) {
                LoadersUtils.log(e);
            }
            catch (IllegalAccessException e) {
                LoadersUtils.log(e);
            }
            catch (InvocationTargetException e) {
                LoadersUtils.log(e);
            }
        }
    }

    private void processEclipseFolder() {
        String eclipseFolder = standaloneConfiguration.getEclipseFolder();
        this.processEclipseFolder(eclipseFolder);
        File linksFolder = new File(eclipseFolder + "/links");
        if (linksFolder.exists()) {
            this.processLinksFolder(linksFolder);
        }
    }

    private void processEclipseFolder(String eclipseFolder) {
        if (eclipseFolder != null) {
            if (this.alreadyProcessedEclipseFolders.contains(eclipseFolder)) {
                return;
            }
            this.alreadyProcessedEclipseFolders.add(eclipseFolder);
            File folder = new File(eclipseFolder + "/plugins");
            if (folder.exists()) {
                File[] folders = folder.listFiles();
                int i = folders.length - 1;
                while (i >= 0) {
                    File pluginFile = new File(folders[i].getAbsolutePath() + "/plugin.xml");
                    if (pluginFile.exists()) {
                        String pluginXMLFileName = pluginFile.getAbsolutePath();
                        if (!standaloneConfiguration.getPluginsXMLFiles().contains(pluginXMLFileName)) {
                            standaloneConfiguration.getPluginsXMLFiles().add(pluginXMLFileName);
                        }
                    }
                    --i;
                }
            }
        }
    }

    private void processExtensions() {
        Iterator iter = standaloneConfiguration.getExtensionsList().iterator();
        while (iter.hasNext()) {
            HyadesConfigurationElement element = (HyadesConfigurationElement)iter.next();
            if (!element.getDeclaringExtensionName().endsWith("." + this.extensionPointID)) continue;
            this.internalReadElement(element);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processLinksFolder(File linksFolder) {
        File[] files = linksFolder.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".link");
            }
        });
        int i = files.length - 1;
        while (i >= 0) {
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(files[i]));
                while ((line = bufferedReader.readLine()) != null) {
                    void var5_6;
                    if (!var5_6.startsWith("path=")) continue;
                    line = var5_6.substring("path=".length()).trim();
                    this.processEclipseFolder(line + "/eclipse");
                }
                bufferedReader.close();
            }
            catch (FileNotFoundException e) {
                LoadersUtils.log(e);
            }
            catch (IOException e) {
                LoadersUtils.log(e);
            }
            --i;
        }
    }

    private void processPluginXMLFiles() {
        ArrayList<String> alredyProcessed = new ArrayList<String>();
        Iterator iter = standaloneConfiguration.getPluginsXMLFiles().iterator();
        while (iter.hasNext()) {
            try {
                String element = (String)iter.next();
                if (alredyProcessed.contains(element)) continue;
                alredyProcessed.add(element);
                Document document = XMLUtil.getXmlDom(element);
                NodeList nodeList = document.getElementsByTagName("extension");
                int i = nodeList.getLength() - 1;
                while (i >= 0) {
                    Node extension = nodeList.item(i);
                    standaloneConfiguration.getExtensionsList().add(new HyadesConfigurationElement(extension));
                    --i;
                }
            }
            catch (RuntimeException e) {
                LoadersUtils.log(e);
            }
        }
    }

    private synchronized void standaloneReadRegistry() {
        if (standaloneConfiguration != null) {
            if (!standaloneConfiguration.isAlreadyProcessed()) {
                this.alreadyProcessedEclipseFolders = new ArrayList();
                this.processEclipseFolder();
                this.processPluginXMLFiles();
                this.processEMFpackages();
                RegistryReader.standaloneConfiguration.alreadyProcessed = true;
            }
            this.processExtensions();
        }
    }

    static {
        mode = 0;
    }

    public static final class StandaloneConfiguration {
        protected List emfPackageClassesList = new ArrayList();
        protected List extensionsList = new ArrayList();
        protected List pluginsXMLFiles = new ArrayList();
        protected String eclipseFolder;
        protected boolean alreadyProcessed = false;

        public boolean isAlreadyProcessed() {
            return this.alreadyProcessed;
        }

        public void setEclipseFolder(String string) {
            this.eclipseFolder = string;
        }

        public String getEclipseFolder() {
            return this.eclipseFolder;
        }

        public List getEmfPackageClassesList() {
            return this.emfPackageClassesList;
        }

        public List getExtensionsList() {
            return this.extensionsList;
        }

        public List getPluginsXMLFiles() {
            return this.pluginsXMLFiles;
        }
    }
}

