/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.java;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.eclipse.hyades.internal.logging.core.XmlGenerator;
import org.eclipse.hyades.logging.core.IExternalizableToXml;

public class XmlFormatter
extends Formatter {
    private XmlGenerator xmlGenerator = new XmlGenerator();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public String format(LogRecord record) {
        if (record instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)record).externalizeCanonicalXmlString().concat(LINE_SEPARATOR);
        }
        if (this.xmlGenerator == null) {
            this.xmlGenerator = new XmlGenerator();
        }
        this.xmlGenerator.reset(null, true, 4);
        return this.xmlGenerator.objectToXML((Object)record).concat(LINE_SEPARATOR);
    }
}

