/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.hyades.execution.security.IClientHandler;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;

public class FileClientHandlerImpl
extends Thread
implements IClientHandler,
FileServiceConstants,
Constants {
    private Socket _socket;
    private InputStream _instrm;
    private OutputStream _outstrm;
    private byte[] _data;
    private int byteCount;
    private int count;

    public FileClientHandlerImpl(Socket s) {
        this._socket = s;
        try {
            this._instrm = s.getInputStream();
            this._outstrm = s.getOutputStream();
        }
        catch (IOException e) {}
    }

    public byte[] getRemoteAddress() {
        return this._socket.getInetAddress().getAddress();
    }

    public int read(byte[] b, int off, int len) {
        int bytesRead;
        try {
            bytesRead = this._instrm.read(b, off, len);
        }
        catch (IOException ioe) {
            bytesRead = -1;
        }
        return bytesRead;
    }

    public int write(byte[] b, int off, int len) {
        try {
            this._outstrm.write(b, off, len);
        }
        catch (IOException ioe) {
            return -1;
        }
        return 0;
    }

    public void closeConnection() {
        block4: {
            try {
                this._instrm.close();
                this._outstrm.close();
                this._socket.close();
            }
            catch (IOException ioe) {
                if (this._socket.isClosed()) break block4;
                try {
                    this._socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public int write(byte[] b) {
        try {
            this._outstrm.write(b);
        }
        catch (IOException ioe) {
            return -9;
        }
        return 0;
    }

    public int read(byte[] b) {
        int bytesRead;
        try {
            bytesRead = this._instrm.read(b);
        }
        catch (IOException ioe) {
            bytesRead = -1;
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFile(String fileName) {
        BufferedInputStream _fis = null;
        try {
            try {
                this._data = new byte[1024];
                _fis = new BufferedInputStream(new FileInputStream(fileName));
                while ((this.count = _fis.read(this._data)) != -1) {
                    this.write(this._data, 0, this.count);
                    this.byteCount += this.count;
                }
                _fis.close();
            }
            catch (Throwable e1) {
                try {
                    _fis.close();
                }
                catch (IOException e2) {
                }
                Object var6_4 = null;
                this.closeConnection();
            }
            Object var6_3 = null;
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.closeConnection();
            throw throwable;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putFile(String destFileName) {
        FilterOutputStream _fos = null;
        try {
            try {
                boolean successful;
                File destFile = new File(destFileName);
                if (!destFile.isAbsolute()) {
                    throw new IOException();
                }
                String directoryName = destFile.getParent();
                File dirFile = new File(directoryName);
                if (!dirFile.exists() && !(successful = dirFile.mkdirs())) {
                    throw new IOException();
                }
                File _file = new File(destFileName);
                _file.createNewFile();
                _fos = new BufferedOutputStream(new FileOutputStream(_file));
                this._data = new byte[1024];
                this._socket.setSoTimeout(3000);
                while ((this.count = this.read(this._data)) != -1) {
                    ((BufferedOutputStream)_fos).write(this._data, 0, this.count);
                    this.byteCount += this.count;
                }
                ((BufferedOutputStream)_fos).flush();
                _fos.close();
            }
            catch (Throwable e) {
                try {
                    this._outstrm.write(-9);
                    _fos.close();
                }
                catch (IOException e2) {
                }
                Object var8_11 = null;
                this.closeConnection();
            }
            Object var8_10 = null;
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeConnection();
            throw throwable;
        }
        return 0;
    }

    private int deleteFile(String fileName) {
        return 0;
    }

    public void run() {
        this._data = new byte[1024];
        int offset = 0;
        int result = -1;
        int count = this.read(this._data);
        long operation = Message.readRALongFromBuffer((byte[])this._data, (int)offset);
        long len = Message.readRALongFromBuffer((byte[])this._data, (int)(offset += 4));
        offset += 4;
        String fileName = null;
        try {
            fileName = new String(this._data, offset, (int)len, "UTF-8");
        }
        catch (Throwable e) {
            fileName = new String(this._data, offset, (int)len);
        }
        switch ((int)operation) {
            case 1: {
                result = this.getFile(fileName);
                break;
            }
            case 2: {
                result = this.putFile(fileName);
                break;
            }
            case 3: {
                result = this.deleteFile(fileName);
                break;
            }
        }
    }
}

