/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.hyades.loaders.util.IXMLLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXFragmentHandler
extends DefaultHandler
implements XMLFragmentHandler {
    protected InputSource inputSource = null;
    protected ParserPipedInputStream xmlStream = null;
    protected SAXParser parser;
    protected Thread parseThread;
    protected IXMLLoader handler;
    protected int depth;
    protected static final int WAIT_TIME = 500;
    protected byte[] rootTag;
    protected volatile boolean rootTagRequired;
    protected boolean restart;

    public void setXMLLoader(IXMLLoader loader) {
        this.handler = loader;
        this.init();
    }

    public void init() {
        try {
            this.initRestart();
            this.depth = -1;
            this.rootTagRequired = false;
            this.parser = this.makeParser();
            this.xmlStream = new ParserPipedInputStream(this);
            this.parseThread = new Thread(Thread.currentThread().getThreadGroup(), "xmlParserThread"){

                public void run() {
                    do {
                        if (SAXFragmentHandler.this.xmlStream == null) {
                            return;
                        }
                        SAXFragmentHandler.this.parse();
                    } while (SAXFragmentHandler.this.restart);
                    SAXFragmentHandler.this.xmlStream = null;
                }
            };
            this.parseThread.start();
        }
        catch (Exception e) {
            LoadersUtils.log(e);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.restart = false;
        if (this.depth == 0 && this.xmlStream != null) {
            this.xmlStream.makeClosed();
            this.xmlStream = null;
        }
        this.depth = -1;
        this.handler.endDocument(null, 0);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handler.endElement(qName, 0);
        --this.depth;
        if (this.depth == 0) {
            if (this.xmlStream != null) {
                this.xmlStream.makeClosed();
                this.xmlStream = null;
            }
            this.restart = false;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatalError(SAXParseException e) throws SAXException {
        SAXFragmentHandler sAXFragmentHandler = this;
        synchronized (sAXFragmentHandler) {
            if (this.restart && this.depth == 1) {
                this.depth = -1;
                this.rootTagRequired = true;
                try {
                    this.parser = this.makeParser();
                    if (this.xmlStream == null) {
                        this.xmlStream = new ParserPipedInputStream(this);
                    }
                    this.xmlStream.makeOpened();
                }
                catch (ParserConfigurationException e1) {
                    LoadersUtils.log(e1);
                    throw new InvalidXMLException(e1);
                }
                catch (SAXException e1) {
                    LoadersUtils.log(e1);
                    throw new InvalidXMLException(e1);
                }
                return;
            }
        }
        throw e;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    public void scanContent(byte[] fragment, int offset, int length) throws InvalidXMLException {
        if (this.xmlStream != null) {
            if (this.restart && this.rootTagRequired && this.rootTag != null) {
                this.xmlStream.writeBuf(this.rootTag, 0, this.rootTag.length);
                this.rootTagRequired = false;
            }
            this.xmlStream.writeBuf(fragment, offset, length);
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.depth = 0;
        this.handler.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.depth;
        if (this.restart && this.depth == 1 && this.rootTag == null) {
            this.rootTag = ("<" + qName + ">").getBytes();
        }
        this.handler.startElement(qName, false, attributes.getLength() == 0);
        int i = 0;
        while (i < attributes.getLength()) {
            this.handler.attributeName(attributes.getQName(i));
            this.handler.attributeValueCharacters(attributes.getValue(i));
            ++i;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateParser() {
        this.restart = false;
        this.depth = -1;
        if (this.xmlStream != null) {
            this.xmlStream.makeClosed();
            this.xmlStream = null;
        }
        SAXFragmentHandler sAXFragmentHandler = this;
        synchronized (sAXFragmentHandler) {
            this.notifyAll();
            this.parseThread.interrupt();
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/string-interning", true);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    protected synchronized void parse() throws InvalidXMLException {
        try {
            this.inputSource = new InputSource(this.xmlStream);
            this.parser.parse(this.inputSource, (DefaultHandler)this);
        }
        catch (Exception e) {
            if (this.restart) {
                return;
            }
            this.handler.error(new InvalidXMLException(e));
        }
    }

    private void initRestart() {
        this.restart = false;
        try {
            this.parser = this.makeParser();
            if (this.parser.getClass().getName().equals("org.apache.crimson.jaxp.SAXParserImpl")) {
                this.restart = true;
            }
        }
        catch (ParserConfigurationException e1) {
        }
        catch (SAXException e1) {}
    }

    public static class ParserPipedInputStream
    extends InputStream {
        private byte[] inBuf;
        private boolean closed = false;
        private int inCount;
        private long inTotalLength;
        private long inPartLength;
        private int inPos;
        private SAXFragmentHandler handler;

        public ParserPipedInputStream(SAXFragmentHandler handler) {
            this.handler = handler;
            this.inTotalLength = 0L;
            this.inPartLength = 0L;
            this.inCount = 0;
            this.inPos = 0;
        }

        protected synchronized void makeOpened() {
            this.inPartLength = 0L;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = false;
            this.notifyAll();
        }

        public synchronized int available() throws IOException {
            this.waitForNewData();
            return this.inCount;
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public synchronized boolean hasEmptyBuffer() {
            return this.inCount == 0;
        }

        public synchronized void mark(int arg0) {
            super.mark(arg0);
        }

        public boolean markSupported() {
            return false;
        }

        public synchronized int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            --this.inCount;
            return this.inBuf[this.inPos++];
        }

        public synchronized int read(byte[] outBuf, int offset, int length) throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int readBytes = Math.min(this.inCount, length);
            System.arraycopy(this.inBuf, this.inPos, outBuf, offset, readBytes);
            this.inPos += readBytes;
            this.inCount -= readBytes;
            return readBytes;
        }

        public int read(byte[] arg0) throws IOException {
            return this.read(arg0, 0, arg0.length);
        }

        public synchronized void reset() throws IOException {
            super.reset();
        }

        public synchronized long skip(long arg0) throws IOException {
            if ((arg0 += (long)this.inPos) < this.inTotalLength) {
                this.inPos = (int)arg0;
                return arg0;
            }
            return -1L;
        }

        public synchronized void writeBuf(byte[] buf, int offset, int length) {
            if (buf == null || length == 0) {
                return;
            }
            this.inBuf = buf;
            this.inPos = offset;
            this.inTotalLength += (long)length;
            this.inPartLength += (long)length;
            this.inCount = length;
            this.notifyAll();
            this.waitForEmptyBuffer();
        }

        protected synchronized void makeClosed() {
            this.inPartLength = 0L;
            this.inBuf = null;
            this.inCount = 0;
            this.inPos = 0;
            this.closed = true;
            this.notifyAll();
        }

        private void waitForEmptyBuffer() {
            while (!this.hasEmptyBuffer() && !this.closed) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!this.hasEmptyBuffer() && !this.closed) continue;
                    return;
                }
            }
        }

        private synchronized void waitForNewData() {
            boolean notify = true;
            while (this.hasEmptyBuffer()) {
                if (notify) {
                    this.notifyAll();
                    notify = false;
                }
                if (this.closed) {
                    return;
                }
                try {
                    this.wait(500L);
                    if (!this.handler.restart || !this.hasEmptyBuffer() || this.inPartLength <= 0L) continue;
                    try {
                        if (this.handler.depth == 0) {
                            this.makeClosed();
                            this.handler.rootTagRequired = true;
                            return;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!this.closed) continue;
                    return;
                }
            }
        }
    }
}

