/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ResourceUtil;

public class ExecutionUtil {
    public static List findExecutionResults(final TPFTest test) {
        if (test != null && test.eResource() != null) {
            URI uri = test.eResource().getURI().trimFileExtension();
            final ResourceSet resourceSet = test.eResource().getResourceSet();
            final String executionPrefix = uri.lastSegment().toString();
            ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                public Object visit(IFile file) {
                    TPFExecutionResult executionResult;
                    EObject[] eObjects;
                    if (file.getName().startsWith(executionPrefix) && (eObjects = ResourceUtil.load(resourceSet, file)).length == 1 && eObjects[0] instanceof TPFExecutionResult && (executionResult = (TPFExecutionResult)eObjects[0]).getTest() == test) {
                        return executionResult;
                    }
                    return null;
                }
            };
            return (List)ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), new String[]{"execution"}, visitor).get("execution");
        }
        return Collections.EMPTY_LIST;
    }

    public static Map findExecutionResults(List tests) {
        if (tests != null && !tests.isEmpty()) {
            ResourceSet resourceSet = null;
            HashSet<String> resourcePrefixes = new HashSet<String>(tests.size() + 1);
            Iterator i = tests.iterator();
            while (i.hasNext()) {
                TPFTest test;
                Object object = i.next();
                if (!(object instanceof TPFTest) || (test = (TPFTest)object).eResource() == null) continue;
                if (resourceSet == null) {
                    resourceSet = test.eResource().getResourceSet();
                }
                URI uri = test.eResource().getURI().trimFileExtension();
                resourcePrefixes.add(uri.lastSegment().toString());
            }
            if (!resourcePrefixes.isEmpty()) {
                final ResourceSet finalResourceSet = resourceSet;
                final String[] prefixes = resourcePrefixes.toArray(new String[resourcePrefixes.size()]);
                final HashMap ret = new HashMap(resourcePrefixes.size() + 1, 1.0f);
                ResourceUtil.IGetFilesVisitor visitor = new ResourceUtil.IGetFilesVisitor(){

                    public Object visit(IFile file) {
                        int i = 0;
                        int maxi = prefixes.length;
                        while (i < maxi) {
                            EObject[] eObjects;
                            if (file.getName().startsWith(prefixes[i]) && (eObjects = ResourceUtil.load(finalResourceSet, file)).length == 1 && eObjects[0] instanceof TPFExecutionResult) {
                                TPFExecutionResult executionResult = (TPFExecutionResult)eObjects[0];
                                ArrayList<TPFExecutionResult> executionResults = (ArrayList<TPFExecutionResult>)ret.get(executionResult.getTest());
                                if (executionResults == null) {
                                    executionResults = new ArrayList<TPFExecutionResult>();
                                    ret.put(executionResult.getTest(), executionResults);
                                }
                                executionResults.add(executionResult);
                            }
                            ++i;
                        }
                        return null;
                    }
                };
                ResourceUtil.getFiles(ResourcesPlugin.getWorkspace().getRoot(), new String[]{"execution"}, visitor);
                ret.keySet().retainAll(tests);
                return ret;
            }
        }
        return Collections.EMPTY_MAP;
    }
}

