/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#include <jni.h>
#include "RASocket.h"
#include "RADataTransfer.h"
#include "RABindings.h"
/* Header for class Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton */

#ifndef _Included_Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
#define _Included_Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
#ifdef __cplusplus
extern "C" {
#endif


typedef struct  {
	BOOL dirty;
	BOOL monitored;
	char *agent_name;
	BOOL waitingServiceAvailMessage;
	ra_data_target_hdl_t targetHdl;
	jobject agent_logger;
	RA_AGENT_HANDLE bindingStorage;
}logAgent_t;

extern ra_string_t* logAgent_getCurrentProcessId();

/* 198066 - Thread ID's have different types on different platforms so we'll return
            a TID as defined in RAComm.h
*/
extern TID logAgent_getCurrentThreadId() ;

extern logAgent_t* logAgent_registerAgent(char *name, char *type);

extern void logAgent_deregisterAgent(logAgent_t *agent);

extern void logAgent_logMessage(logAgent_t *agent, char *messageBuffer, ra_uint_t length, ra_dataFormat_t format);
/* Inaccessible static: _serviceAvailable */
/* Inaccessible static: _agentCount */
/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    deregister0
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_deregister0
  (JNIEnv *, jobject, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    initializeEngine0
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_initializeEngine0
  (JNIEnv *, jobject, jstring, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessage0
 * Signature: (Ljava/lang/String;[BII)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessage0__Ljava_lang_String_2_3BII
  (JNIEnv *, jobject, jstring, jbyteArray, jint, jint);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessage0
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessage0__Ljava_lang_String_2Ljava_lang_String_2
  (JNIEnv *, jobject, jstring, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessageUTF80
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessageUTF80
  (JNIEnv *, jobject, jstring, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessageUTF81
 * Signature: (Ljava/lang/String;[B)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessageUTF81
  (JNIEnv *, jobject, jstring, jbyteArray);


/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessage0
 * Signature: (Ljava/lang/String;J)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessage0__Ljava_lang_String_2J
  (JNIEnv *, jobject, jstring, jlong);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessage0
 * Signature: ([BIIJ)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessage0___3BIIJ
  (JNIEnv *, jobject, jbyteArray, jint, jint, jlong);

/*
 * Class:     org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessageBinary0
 * Signature: ([BIIJ)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessageBinary0
  (JNIEnv *, jobject, jbyteArray, jint, jint, jlong);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    requestMonitorThroughPeer0
 * Signature: ([BLjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0___3BLjava_lang_String_2
  (JNIEnv *, jobject, jbyteArray, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    requestMonitorThroughPeer0
 * Signature: ([BJLjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0___3BJLjava_lang_String_2
  (JNIEnv *, jobject, jbyteArray, jlong, jstring);


#ifdef __cplusplus
}
#endif
#endif
