/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

class TestSuiteTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String SPACE = "   ";
    private boolean isEnabled = true;

    TestSuiteTreeCellRenderer() {
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        NamedElement namedElement;
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        String string = null;
        int n2 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        if (object instanceof NamedElement) {
            namedElement = (NamedElement)object;
            boolean bl7 = bl6 = namedElement.getExecutionId() <= ModelUtil.DEFAULT_EXECUTION_MANAGER.getCurrentExecutionId();
        }
        if (object instanceof TestSuite) {
            string = "msuite.gif";
        } else if (object instanceof Loop) {
            string = "loop.gif";
        } else if (object instanceof TestInvocation) {
            namedElement = (TestInvocation)object;
            string = "invocation.gif";
            if (((TestInvocation)namedElement).getVerdictEvent() != null) {
                n2 = 2;
            }
            if (((TestInvocation)namedElement).getExecutionCount() > 0) {
                this.setText(this.getText() + SPACE + "#" + ((TestInvocation)namedElement).getExecutionCount());
            } else {
                Action action;
                int n3;
                boolean bl8 = bl5 = ModelUtil.DEFAULT_EXECUTION_MANAGER.isExecutable(namedElement) && namedElement.getExecutionId() <= ModelUtil.DEFAULT_EXECUTION_MANAGER.getCurrentExecutionId();
                if (bl5 && (n3 = ((Action)namedElement).getOwner().getActions().indexOf(namedElement)) > 0 && (action = (Action)((Action)namedElement).getOwner().getActions().get(n3 - 1)).isSynchronous() && action instanceof TestInvocation) {
                    bl6 = bl5 = ((TestInvocation)action).getVerdictEvent() != null;
                }
            }
        } else {
            this.setToolTipText(null);
        }
        if (((Component)this).getFont() != null) {
            this.setFont(((Component)this).getFont().deriveFont(0));
        }
        this.internalSetEnabled(bl6);
        if (this.isEnabled && bl5) {
            this.setForeground(Color.blue);
            this.setFont(((Component)this).getFont().deriveFont(1));
            if (this.getText() != null) {
                this.setText(this.getText().trim());
            }
        }
        this.setIcon(SwingUtil.getIcon(string, n2, this.isEnabled));
        return this;
    }

    private void internalSetEnabled(boolean bl) {
        this.isEnabled = bl;
        if (!bl) {
            this.setForeground(Color.gray);
        }
    }
}

