/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.remote;

import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public class QueueManager {
    private String[] _queue = new String[100];
    private int _lastMessageIndex = -1;
    private boolean _rolledOver = false;

    public synchronized void flushCurrentQueue(RemoteComponentSkeleton remoteComponentSkeleton) {
        try {
            int n;
            if (this._rolledOver) {
                n = this._lastMessageIndex + 1;
                while (n < this._queue.length) {
                    if (this._queue[n] != null) {
                        remoteComponentSkeleton.logMessageUTF8(this._queue[n]);
                    }
                    this._queue[n] = null;
                    ++n;
                }
            }
            n = 0;
            while (n <= this._lastMessageIndex) {
                remoteComponentSkeleton.logMessageUTF8(this._queue[n]);
                this._queue[n] = null;
                ++n;
            }
            this._rolledOver = false;
            this._lastMessageIndex = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void insertInQueue(String string) {
        this._queue[++this._lastMessageIndex] = string;
        if (this._lastMessageIndex == this._queue.length - 1) {
            this._lastMessageIndex = -1;
            this._rolledOver = true;
        }
    }

    public boolean isFlushNeeded() {
        return this._lastMessageIndex != -1 || this._rolledOver;
    }
}

