/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.InvocationEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.common.junit.HyadesTestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTest;
import org.eclipse.hyades.test.common.util.BaseString;

public class HyadesTestRunner
implements TestListener {
    protected static final boolean SYSOUT = false;
    private Test rootTest;
    private Collection succeedTests = Collections.synchronizedCollection(new ArrayList());
    private Collection failureTests = Collections.synchronizedCollection(new ArrayList());
    private Collection errorTests = Collections.synchronizedCollection(new ArrayList());

    public Test getRoot() {
        return this.rootTest;
    }

    protected void setRoot(Test test) {
        this.rootTest = test;
    }

    public Collection getSucceedTests() {
        return this.succeedTests;
    }

    public Collection getFailureTests() {
        return this.failureTests;
    }

    public Collection getErrorTests() {
        return this.errorTests;
    }

    public void run(Class clazz) {
        this.run(new HyadesTestSuite(clazz));
    }

    public void run(Test test) {
        long l;
        this.setRoot(test);
        TestResult testResult = this.createTestResult();
        testResult.addListener((TestListener)this);
        this.runnerStarted();
        long l2 = this.getCurrentTime();
        try {
            test.run(testResult);
            Object var6_4 = null;
            l = this.getCurrentTime();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            long l3 = this.getCurrentTime();
            this.runnerExit(testResult == null || testResult.shouldStop(), l3 - l2);
            throw throwable;
        }
        this.runnerExit(testResult == null || testResult.shouldStop(), l - l2);
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected void runnerStarted() {
        int n = HyadesTestUtil.countTests(new Test[]{this.getRoot()});
    }

    protected void runnerExit(boolean bl, long l) {
        this.writeEvent(this.getDefaultVerdictEvent(this.getRoot()));
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(this.getRoot()));
        typedEvent.setType(1);
        typedEvent.setText(this.getLastEventText(bl, l));
        this.writeEvent(typedEvent);
    }

    protected String getLastEventText(boolean bl, long l) {
        return null;
    }

    public void startTest(Test test) {
        Object object;
        if (test instanceof IHyadesTest && (object = (IHyadesTest)test).getTestInvocationId() != null) {
            String string = HyadesTestUtil.getHierarchyIds(object.getParent());
            string = HyadesTestUtil.appendToHierarchyId(string, object.getTestInvocationId(), object.getIteration());
            InvocationEvent invocationEvent = new InvocationEvent();
            invocationEvent.setOwnerId(string);
            invocationEvent.setStatus(1);
            invocationEvent.setReason(1);
            invocationEvent.setInvokedId(HyadesTestUtil.getHierarchyIds((Test)object));
            this.writeEvent(invocationEvent);
        }
        object = new TypedEvent();
        ((ExecutionEvent)object).setOwnerId(HyadesTestUtil.getHierarchyIds(test));
        ((TypedEvent)object).setType(0);
        this.writeEvent((ExecutionEvent)object);
    }

    public void endTest(Test test) {
        if (test == this.getRoot()) {
            return;
        }
        if (test instanceof TestCase && !this.getFailureTests().contains(test) && !this.getErrorTests().contains(test)) {
            this.getSucceedTests().add(test);
        }
        this.writeEvent(this.getDefaultVerdictEvent(test));
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(test));
        typedEvent.setType(1);
        this.writeEvent(typedEvent);
    }

    protected VerdictEvent getDefaultVerdictEvent(Test test) {
        VerdictEvent verdictEvent = null;
        if (test instanceof TestSuite) {
            HyadesTestSuite hyadesTestSuite;
            if (test instanceof HyadesTestSuite && (hyadesTestSuite = (HyadesTestSuite)test).getArbiter() != null && (verdictEvent = hyadesTestSuite.getArbiter().analyse(hyadesTestSuite, this.filterTests(test, this.getSucceedTests()), this.filterTests(test, this.getErrorTests()), this.filterTests(test, this.getFailureTests()))) != null && verdictEvent.getOwnerId() == null) {
                verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(test));
            }
        } else if (test instanceof TestCase && !this.getFailureTests().contains(test) && !this.getErrorTests().contains(test)) {
            verdictEvent = new VerdictEvent();
            verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(test));
            verdictEvent.setVerdict(1);
        }
        return verdictEvent;
    }

    public void addError(Test test, Throwable throwable) {
        this.getErrorTests().add(test);
        VerdictEvent verdictEvent = new VerdictEvent();
        verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(test));
        verdictEvent.setVerdict(3);
        verdictEvent.setReason(2);
        verdictEvent.setText(BaseString.getStackTrace(throwable));
        this.writeEvent(verdictEvent);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.getFailureTests().add(test);
        VerdictEvent verdictEvent = new VerdictEvent();
        verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(test));
        verdictEvent.setVerdict(2);
        verdictEvent.setReason(2);
        verdictEvent.setText(BaseString.getStackTrace((Throwable)assertionFailedError));
        this.writeEvent(verdictEvent);
    }

    protected void writeEvent(ExecutionEvent executionEvent) {
        if (executionEvent != null) {
            System.out.println(executionEvent);
        }
    }

    protected Collection filterTests(Test test, Collection collection) {
        Test[] testArray = collection.toArray(new Test[collection.size()]);
        ArrayList<Test> arrayList = new ArrayList<Test>(testArray.length);
        int n = 0;
        int n2 = testArray.length;
        while (n < n2) {
            if (testArray[n] instanceof IHyadesTest && HyadesTestUtil.isParentOf(test, testArray[n])) {
                arrayList.add(testArray[n]);
            }
            ++n;
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

