/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBELogOutputter
extends ProcessUnit
implements IOutputter {
    private LoggingAgent cbelogger = null;
    private static String defaultAgentName = "GenericAdapterCBELogger";
    private String agentName = null;
    private long waitTime = 0L;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return this.processCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        if (iCommonBaseEventArray.length > 0 && !this.cbelogger.isLogging() && this.getWaitTime() > 0L) {
            this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info", this.getUniqueID(), this.getAgentName()), (short)10);
            while (!this.cbelogger.waitUntilLogging(this.getWaitTime())) {
                this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Waiting_Info", this.getUniqueID(), this.getAgentName()), (short)10);
            }
        }
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                try {
                    this.cbelogger.write(iCommonBaseEventArray[n].toString());
                }
                catch (Exception exception) {
                    this.log(Messages.getString("HyadesGA_CBE_Logging_Agent_Write_Error", this.getUniqueID(), this.getAgentName()), (short)60);
                }
            }
            ++n;
        }
        return iCommonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof ICommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
        }
        return this.testProcessCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        return iCommonBaseEventArray;
    }

    public void update() throws AdapterInvalidConfig {
        String string;
        super.update();
        Element element = null;
        Element element2 = this.getConfiguration();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                element = (Element)nodeList.item(n);
            }
            ++n;
        }
        if (element.hasAttribute(Messages.getString("HyadesGAwaitTimeAttributeName")) && (string = element.getAttribute(Messages.getString("HyadesGAwaitTimeAttributeName"))) != null && !string.equals("")) {
            this.setWaitTime(Long.valueOf(string));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAagentNameAttributeName"))) {
            this.setAgentName(element.getAttribute(Messages.getString("HyadesGAagentNameAttributeName")));
        }
        if (this.cbelogger == null) {
            string = this.getAgentName() == null ? defaultAgentName : this.getAgentName();
            this.cbelogger = new LoggingAgent(string);
        }
    }

    public void setAgentName(String string) {
        this.agentName = string;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setWaitTime(long l) {
        this.waitTime = l;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void stop() {
        this.cbelogger.deregister();
    }
}

