/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.impl;

import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.core.impl.ExecutionComponentImpl;
import org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject;
import org.eclipse.hyades.execution.core.impl.JavaTaskExecutableObject;

public class JavaTaskExecutorImpl
extends ExecutionComponentImpl
implements IExecutor {
    private IExecutableObject executable;

    public void launch() throws ExecutionComponentStateException {
        this.checkConfiguration();
        ((IJavaTaskExecutableObject)this.executable).start();
    }

    public void kill() throws ExecutionComponentStateException {
        this.checkConfiguration();
        ((JavaTaskExecutableObject)this.executable).stop();
    }

    public void setExecutableObject(IExecutableObject iExecutableObject) throws ExecutionComponentStateException {
        this.executable = iExecutableObject;
    }

    public IExecutableObject getExecutableObject() {
        return this.executable;
    }

    public IProcessConsole getProcessConsole() throws ExecutionComponentStateException {
        return null;
    }

    public IExecutableObject getCompatibleExecutableObject(String string) throws ClassNotFoundException {
        throw new UnsupportedOperationException("This operation is implemented in the stub");
    }

    protected void checkConfiguration() throws ExecutionComponentStateException {
        if (this.executable == null) {
            throw new ExecutionComponentStateException(1, "This executor has not been configured with an executable object");
        }
        if (!(this.executable instanceof IJavaTaskExecutableObject)) {
            throw new ExecutionComponentStateException(1, "The executable object is not an IJavaTaskExecutableObject");
        }
    }

    public boolean supportsControlEvent(String string) {
        return false;
    }

    public String performControlEvent(String string) {
        return "";
    }
}

