/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.security;

import java.io.IOException;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.eclipse.hyades.execution.security.IConnectionHandler;
import org.eclipse.hyades.execution.security.IKeystoreManager;
import org.eclipse.hyades.execution.security.ISecureServerParameters;

public final class SecureServer
implements Runnable {
    private SSLServerSocket sslsocket;
    private IConnectionHandler connectionHandler;

    private IKeystoreManager loadKeystore(ISecureServerParameters iSecureServerParameters) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        IKeystoreManager iKeystoreManager = iSecureServerParameters.getKeystoreManager();
        iKeystoreManager.setProvider(iSecureServerParameters.getSecurityProvider());
        iKeystoreManager.loadKeystore(iSecureServerParameters.getKeystoreFileName(), iSecureServerParameters.getKeystoreFilepassword());
        return iKeystoreManager;
    }

    public void init(ISecureServerParameters iSecureServerParameters) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, CertificateException, IOException {
        int n = 0;
        IKeystoreManager iKeystoreManager = null;
        Security.addProvider(iSecureServerParameters.getSecurityProvider());
        iKeystoreManager = this.loadKeystore(iSecureServerParameters);
        String[] stringArray = iSecureServerParameters.getEnabledProtocols();
        if (stringArray == null) {
            stringArray = new String[]{"SSL"};
        }
        SSLContext sSLContext = null;
        while (true) {
            try {
                sSLContext = SSLContext.getInstance(stringArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (++n != stringArray.length) continue;
                throw noSuchAlgorithmException;
                if (n < stringArray.length) continue;
            }
            break;
        }
        sSLContext.init(iKeystoreManager.getKeyManagers(), iKeystoreManager.getTrustManagers(), null);
        this.sslsocket = (SSLServerSocket)sSLContext.getServerSocketFactory().createServerSocket(iSecureServerParameters.getPort());
        this.sslsocket.setNeedClientAuth(iSecureServerParameters.clientAuthenticationRequired());
        try {
            this.sslsocket.setWantClientAuth(iSecureServerParameters.clientAuthenticationRequired());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String[] stringArray2 = iSecureServerParameters.getEnabledCipherSuites();
        if (stringArray2 != null) {
            this.sslsocket.setEnabledCipherSuites(iSecureServerParameters.getEnabledCipherSuites());
        } else {
            this.sslsocket.setEnabledCipherSuites(this.sslsocket.getEnabledCipherSuites());
        }
        this.sslsocket.setEnableSessionCreation(true);
        this.connectionHandler = iSecureServerParameters.getConnectionHandler();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    SSLSocket sSLSocket = (SSLSocket)this.sslsocket.accept();
                    sSLSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        }
                    });
                    SSLSession sSLSession = sSLSocket.getSession();
                    if (sSLSession == null || sSLSession.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL") || this.connectionHandler == null) continue;
                    this.connectionHandler.connectionAccepted(sSLSocket);
                }
            }
            catch (SocketException socketException) {
                SecureServer secureServer = this;
                synchronized (secureServer) {
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                continue;
            }
            break;
        }
    }

    public synchronized void quit() {
        try {
            this.sslsocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

