/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBEFileOutputter
extends ProcessUnit
implements IOutputter {
    private String directory = null;
    private String fileName = null;
    private String rawLogFileName = null;
    private File outputFile = null;
    private FileWriter fw = null;

    public Object[] processEventItems(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return this.processCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] processCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        int n = 0;
        while (n < iCommonBaseEventArray.length) {
            if (iCommonBaseEventArray[n] != null) {
                try {
                    this.fw.write(iCommonBaseEventArray[n].toString() + "\n");
                    this.fw.flush();
                }
                catch (IOException iOException) {
                    this.log(Messages.getString("HyadesGA_CBE_File_Outputter_Write_Error", this.getUniqueID(), this.rawLogFileName), (short)60);
                }
            }
            ++n;
        }
        return iCommonBaseEventArray;
    }

    public Object[] testProcessEventItems(Object[] objectArray) throws AdapterInvalidConfig {
        if (!(objectArray instanceof ICommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of ICommonBaseEvent");
        }
        return this.testProcessCBEs((ICommonBaseEvent[])objectArray);
    }

    private ICommonBaseEvent[] testProcessCBEs(ICommonBaseEvent[] iCommonBaseEventArray) {
        return iCommonBaseEventArray;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String string) {
        this.directory = string;
    }

    public final void setFileName(String string) {
        this.fileName = string;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String string = null;
        String string2 = null;
        Element element = null;
        Element element2 = this.getConfiguration();
        NodeList nodeList = element2.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1) {
                element = (Element)nodeList.item(n);
            }
            ++n;
        }
        if (element.hasAttribute(Messages.getString("HyadesGAdirectoryAttributeName"))) {
            string = element.getAttribute(Messages.getString("HyadesGAdirectoryAttributeName"));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAfileNameAttributeName"))) {
            string2 = element.getAttribute(Messages.getString("HyadesGAfileNameAttributeName"));
        }
        this.setDirectory(string);
        this.setFileName(string2);
        String string3 = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith(string3) ? this.getDirectory() + this.getFileName() : this.getDirectory() + string3 + this.getFileName();
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException iOException) {
            this.log(Messages.getString("HyadesGA_CBE_File_Outputter_Create_Error", this.getUniqueID(), this.rawLogFileName), (short)60);
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_File_Outputter_Create_Error"));
        }
    }
}

