/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.Parser;
import org.eclipse.hyades.logging.adapter.parsers.PositionParser;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;

public class SubstituteStatement
implements IStatement {
    private static Substitution substitution = new Perl5Substitution();
    String name;
    private String positions;
    private String match;
    private String substitute;
    private Pattern pattern;
    private List positionsList;
    boolean useBuiltin;
    private List path;
    private IDirectedGraph resultGraph;

    public void prepare(Element element, String string) throws PreparationException {
        this.positions = element.getAttribute(Messages.getString("HyadesGAPositionsAttributeName"));
        this.match = element.getAttribute(Messages.getString("HyadesGAMatchAttributeName"));
        this.substitute = element.getAttribute(Messages.getString("HyadesGASubstituteAttributeName"));
        String string2 = element.getAttribute(Messages.getString("HyadesGAuseBuiltInFunctionAttributeName"));
        this.useBuiltin = string2 != null && !string2.equals("") ? string2.equals("true") : false;
        this.name = string;
        this.resultGraph = null;
        this.path = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(91);
            if (n > 0) {
                String string4 = string3.substring(n + 1, string3.length() - 1);
                string3 = string3.substring(0, n);
                this.path.add(string3);
                this.path.add(string4);
                continue;
            }
            this.path.add(string3);
        }
        if (this.positions != null) {
            this.positionsList = PositionParser.getPositionedString(this.positions, true);
        }
        if (this.match != null && !this.match.equals("")) {
            try {
                this.pattern = Parser.getCompiler().compile(this.match);
            }
            catch (MalformedPatternException malformedPatternException) {
                PreparationException preparationException = new PreparationException(Messages.getString("HyadesGAMalformedParserExpression"), malformedPatternException);
                preparationException.setDetails(malformedPatternException.getLocalizedMessage() + " \"" + this.match + "\"|");
                preparationException.setDigraph(this.name);
                throw preparationException;
            }
        }
    }

    public boolean run(String string, HashMap hashMap, List list) {
        String string2;
        boolean bl = false;
        if (this.useBuiltin) {
            this.resultGraph = new DirectedGraphImpl();
            this.resultGraph.setPath(this.path);
            this.resultGraph.setValue("##BUILTIN");
            list.add(this.resultGraph);
            return true;
        }
        if (this.positions != null && !this.positions.equals("")) {
            string = this.positionsToString(string, hashMap);
        }
        if (this.pattern != null && !this.pattern.equals("")) {
            string2 = this.matchAndSubstitute(string);
            if (string2 != null && string.length() == string2.length() && !Parser.getPatternMatcher().contains(string, this.pattern)) {
                bl = false;
            }
            bl = string2 != null;
        } else {
            string2 = this.substitute != null && !this.substitute.equals("") ? this.substitute : string;
            bl = true;
        }
        if (bl) {
            this.resultGraph = new DirectedGraphImpl();
            this.resultGraph.setPath(this.path);
            this.resultGraph.setValue(string2);
            list.add(this.resultGraph);
            return true;
        }
        this.resultGraph = null;
        return false;
    }

    private String matchAndSubstitute(String string) {
        if (this.substitute != null && !this.substitute.equals("")) {
            if (!Parser.getPatternMatcher().contains(string, this.pattern)) {
                return null;
            }
            ((Perl5Substitution)substitution).setSubstitution(this.substitute);
            String string2 = Util.substitute((PatternMatcher)Parser.getPatternMatcher(), (Pattern)this.pattern, (Substitution)substitution, (String)string, (int)-1);
            return string2.trim();
        }
        return null;
    }

    private String positionsToString(String string, HashMap hashMap) {
        if (this.positionsList != null) {
            StringBuffer stringBuffer = new StringBuffer();
            ListIterator listIterator = this.positionsList.listIterator();
            boolean bl = true;
            boolean bl2 = false;
            while (listIterator.hasNext()) {
                Object object;
                Object e = listIterator.next();
                if (bl) {
                    bl = !bl;
                } else {
                    stringBuffer.append("@@");
                }
                if (e instanceof String) {
                    object = (String)hashMap.get(e);
                    if (object != null && ((String)object).length() == 0) {
                        bl2 = true;
                        continue;
                    }
                    stringBuffer.append((String)object);
                    continue;
                }
                if (!(e instanceof Long)) continue;
                object = (Long)e;
                String string2 = null;
                int n = ((Long)object).intValue();
                if (n < 0 || n >= this.positionsList.size()) continue;
                string2 = (String)this.positionsList.get(n);
                stringBuffer.append(string2);
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            if (bl2) {
                return "";
            }
        }
        return string;
    }

    public IDirectedGraph getResultGraph() {
        return this.resultGraph;
    }
}

