/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.junit;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.hyades.test.common.junit.HyadesTestRunner;
import org.eclipse.hyades.test.common.junit.HyadesTestUtil;
import org.eclipse.hyades.test.common.junit.IHyadesTest;
import org.eclipse.hyades.test.common.junit.IHyadesTestArbiter;

public class HyadesTestSuite
extends TestSuite
implements IHyadesTest {
    private String id;
    private String testInvocationId;
    private Test parent;
    private IHyadesTestArbiter arbiter;
    private int iteration = 0;
    private int previousParentIteration = 0;
    private boolean synchronous = true;
    private boolean loop = false;
    private int activeAsynchronousTest;

    public HyadesTestSuite() {
    }

    public HyadesTestSuite(Class clazz) {
        super(clazz);
    }

    public HyadesTestSuite(String string) {
        super(string);
    }

    public String getId() {
        return this.id;
    }

    public IHyadesTest setId(String string) {
        this.id = string;
        return this;
    }

    public String getTestInvocationId() {
        return this.testInvocationId;
    }

    public IHyadesTest setTestInvocationId(String string) {
        this.testInvocationId = string;
        return this;
    }

    public void setParent(Test test) {
        this.parent = test;
    }

    public Test getParent() {
        return this.parent;
    }

    public int getIteration() {
        int n;
        if (!this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread && (n = ((AsynchronousThread)Thread.currentThread()).getIteration(this)) >= 0) {
            return n;
        }
        return this.iteration;
    }

    public IHyadesTest setSynchronous(boolean bl) {
        this.synchronous = bl;
        return this;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public IHyadesTest setLoop(boolean bl) {
        this.loop = bl;
        return this;
    }

    public HyadesTestSuite setArbiter(IHyadesTestArbiter iHyadesTestArbiter) {
        this.arbiter = iHyadesTestArbiter;
        return this;
    }

    public IHyadesTestArbiter getArbiter() {
        return this.arbiter;
    }

    public void addTestSuite(Class clazz) {
        this.addTest(new HyadesTestSuite(clazz));
    }

    public void addTest(Test test) {
        super.addTest(test);
        boolean bl = false;
        if (test instanceof TestDecorator) {
            test = HyadesTestUtil.getDecoratorTest((TestDecorator)test);
            bl = true;
        }
        if (test instanceof IHyadesTest) {
            IHyadesTest iHyadesTest = (IHyadesTest)test;
            iHyadesTest.setParent(this);
            iHyadesTest.setLoop(bl);
        }
    }

    public void run(TestResult testResult) {
        if (this.isSynchronous()) {
            this.doRun(testResult);
        } else {
            final TestResult testResult2 = testResult;
            AsynchronousThread asynchronousThread = new AsynchronousThread("Asynchronous HyadesTestSuite"){

                public void run() {
                    try {
                        HyadesTestSuite.this.doRun(testResult2);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (HyadesTestSuite.this.getParent() instanceof HyadesTestSuite) {
                            ((HyadesTestSuite)HyadesTestSuite.this.getParent()).runFinished(HyadesTestSuite.this);
                        }
                        this.dispose();
                        throw throwable;
                    }
                    if (HyadesTestSuite.this.getParent() instanceof HyadesTestSuite) {
                        ((HyadesTestSuite)HyadesTestSuite.this.getParent()).runFinished(HyadesTestSuite.this);
                    }
                    this.dispose();
                }
            };
            if (this.getParent() instanceof HyadesTestSuite) {
                HyadesTestSuite hyadesTestSuite = (HyadesTestSuite)this.getParent();
                ++hyadesTestSuite.activeAsynchronousTest;
                HyadesTestRunner.seedParentStack(asynchronousThread);
                ((AsynchronousThread)asynchronousThread).setParentThread(Thread.currentThread());
            }
            asynchronousThread.start();
        }
    }

    protected void doRun(TestResult testResult) {
        Iterator iterator;
        HyadesTestSuite hyadesTestSuite = this;
        synchronized (hyadesTestSuite) {
            if (!this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread) {
                if (((AsynchronousThread)Thread.currentThread()).getParentThread() instanceof AsynchronousThread) {
                    this.iteration = ((AsynchronousThread)((AsynchronousThread)Thread.currentThread()).getParentThread()).getCurrentChildIteration();
                }
            } else if (this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread) {
                this.iteration = ((AsynchronousThread)Thread.currentThread()).getIteration(this);
                if (this.iteration == -1) {
                    this.iteration = 0;
                }
            }
            this.adjustIteration();
            if (!this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread) {
                ((AsynchronousThread)Thread.currentThread()).setIteration(this, this.iteration);
                if (((AsynchronousThread)Thread.currentThread()).getParentThread() instanceof AsynchronousThread) {
                    ((AsynchronousThread)((AsynchronousThread)Thread.currentThread()).getParentThread()).setCurrentChildIteration(this.iteration);
                }
            } else if (this.isSynchronous() && Thread.currentThread() instanceof AsynchronousThread) {
                ((AsynchronousThread)Thread.currentThread()).setIteration(this, this.iteration);
            }
            iterator = HyadesTestUtil.getTestListeners(testResult);
            while (iterator.hasNext()) {
                ((TestListener)iterator.next()).startTest((Test)this);
            }
        }
        this.activeAsynchronousTest = 0;
        super.run(testResult);
        this.waitUntilFinished();
        iterator = HyadesTestUtil.getTestListeners(testResult);
        while (iterator.hasNext()) {
            ((TestListener)iterator.next()).endTest((Test)this);
        }
    }

    public void runTest(final Test test, final TestResult testResult) {
        if (test instanceof IHyadesTest && !((IHyadesTest)test).isSynchronous()) {
            Thread thread = new Thread("Asynchronous Test"){

                public void run() {
                    try {
                        test.run(testResult);
                        Object var2_1 = null;
                        HyadesTestSuite.this.runFinished(test);
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        HyadesTestSuite.this.runFinished(test);
                        throw throwable;
                    }
                }
            };
            ++this.activeAsynchronousTest;
            thread.start();
        } else {
            super.runTest(test, testResult);
        }
    }

    protected void adjustIteration() {
        if (this.parent != null) {
            int n = this.getPreviousParentIteration();
            if (this.parent instanceof IHyadesTest) {
                n = HyadesTestSuite.getParentIteration((IHyadesTest)this.parent);
            }
            if (n != this.getPreviousParentIteration()) {
                this.iteration = 0;
                this.setPreviousParentIteration(n);
            }
        }
        ++this.iteration;
    }

    protected int getPreviousParentIteration() {
        Thread thread;
        if (Thread.currentThread() instanceof AsynchronousThread && (thread = ((AsynchronousThread)Thread.currentThread()).getParentThread()) instanceof AsynchronousThread) {
            return ((AsynchronousThread)thread).getPreviousParentIteration(this);
        }
        return this.previousParentIteration;
    }

    protected void setPreviousParentIteration(int n) {
        Thread thread;
        if (Thread.currentThread() instanceof AsynchronousThread && (thread = ((AsynchronousThread)Thread.currentThread()).getParentThread()) instanceof AsynchronousThread) {
            ((AsynchronousThread)thread).setPreviousParentIteration(this, n);
            return;
        }
        this.previousParentIteration = n;
    }

    /*
     * Unable to fully structure code
     */
    protected static int getParentIteration(IHyadesTest var0) {
        var1_1 = var0.getIteration();
        if (!var0.isLoop() || !(Thread.currentThread() instanceof AsynchronousThread) || !((var2_2 = ((AsynchronousThread)Thread.currentThread()).getParentThread()) instanceof AsynchronousThread)) ** GOTO lbl11
        var1_1 = ((AsynchronousThread)var2_2).getIteration(var0);
        return var1_1;
        while ((var2_2 = var0.getParent()) != null && var2_2 instanceof IHyadesTest) {
            var0 = (IHyadesTest)var2_2;
            var1_1 = var0.getIteration();
            if (var0.isLoop() && Thread.currentThread() instanceof AsynchronousThread && (var3_3 = ((AsynchronousThread)Thread.currentThread()).getParentThread()) instanceof AsynchronousThread) {
                var1_1 = ((AsynchronousThread)var3_3).getIteration(var0);
                break;
            }
lbl11:
            // 3 sources

            if (var0 != null && !var0.isLoop()) continue;
        }
        return var1_1;
    }

    protected synchronized void waitUntilFinished() {
        while (this.activeAsynchronousTest > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    protected synchronized void runFinished(Test test) {
        --this.activeAsynchronousTest;
        this.notifyAll();
    }

    public String toJUnitString() {
        return super.toString();
    }

    public String toString() {
        return HyadesTestUtil.getHierarchy(this, false);
    }

    public static String getIterationsString(IHyadesTest iHyadesTest) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = HyadesTestRunner.peekParentEventID();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append('(');
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append(')');
        }
        stringBuffer.append('(');
        if (Thread.currentThread() instanceof AsynchronousThread) {
            int n = ((AsynchronousThread)Thread.currentThread()).getIteration(iHyadesTest);
            if (n > 0) {
                stringBuffer.append(n);
            } else {
                stringBuffer.append(HyadesTestSuite.getParentIteration(iHyadesTest));
            }
        } else {
            stringBuffer.append(HyadesTestSuite.getParentIteration(iHyadesTest));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static class AsynchronousThread
    extends Thread {
        private static int counter = 0;
        private Map iterationByTest = new HashMap();
        private Map previousParentIterationByTest = new HashMap();
        private Thread parentThread = null;
        private int currentChildIteration = 0;

        public AsynchronousThread(String string) {
            super(string + ++counter);
        }

        public void dispose() {
            this.iterationByTest.clear();
            this.previousParentIterationByTest.clear();
        }

        public void setIteration(Test test, int n) {
            this.iterationByTest.put(this.getName() + test.hashCode(), new Integer(n));
        }

        public int getIteration(Test test) {
            Integer n = (Integer)this.iterationByTest.get(this.getName() + test.hashCode());
            if (n == null) {
                return -1;
            }
            return n;
        }

        public void setPreviousParentIteration(Test test, int n) {
            this.previousParentIterationByTest.put(this.getName() + test.hashCode(), new Integer(n));
        }

        public int getPreviousParentIteration(Test test) {
            Integer n = (Integer)this.previousParentIterationByTest.get(this.getName() + test.hashCode());
            if (n == null) {
                return -1;
            }
            return n;
        }

        public Thread getParentThread() {
            return this.parentThread;
        }

        public void setParentThread(Thread thread) {
            this.parentThread = thread;
        }

        public int getCurrentChildIteration() {
            return this.currentChildIteration;
        }

        public void setCurrentChildIteration(int n) {
            this.currentChildIteration = n;
        }
    }
}

