/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;

public class ParseMonitorOwner {
    private Hashtable _idents = null;
    private ThreadDump _threadDump = null;
    private Hashtable _threads = null;
    private Hashtable _monitors = null;
    private Hashtable _ownedMonitors = null;
    private Hashtable _tid = null;
    private Vector deadlockResults = null;
    public static final String FLATLOCKMSG = "Flat locked by thread ident ";
    public static final String FLATLOCKMSG_WITHIDENTASDIGIT = "Flat locked by threadIdent ";
    public static final int FLATLOCKMSG_WITHIDENTASDIGIT_LEN = "Flat locked by threadIdent ".length();
    public static final String FLATLOCKOWNER = "(Flat locked) owner ";
    public static final int FLATLOCKMSG_LEN = "Flat locked by thread ident ".length();
    public static final String OWNERMSG = "owner ";

    public ParseMonitorOwner(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, Hashtable hashtable4, ThreadDump threadDump) {
        this._idents = hashtable;
        this._threadDump = threadDump;
        this._threads = hashtable2;
        this._monitors = hashtable3;
        this._ownedMonitors = new Hashtable();
        this._tid = hashtable4;
    }

    public void doIt(int n) {
        Vector vector = this._threadDump.getThreadDumpVector();
        String string = null;
        int n2 = vector.size();
        int n3 = -1;
        String string2 = null;
        Object var7_7 = null;
        while (n2 >= ++n && (n3 = (string = (String)vector.elementAt(n)).indexOf("JVM System Monitor Dump (registered monitors):")) < 0) {
            n3 = string.indexOf("unowned");
            if (n3 >= 0) {
                this.setMonOwner(string);
                continue;
            }
            n3 = string.indexOf(FLATLOCKMSG);
            if (n3 >= 0) {
                string2 = string.substring(n3 + FLATLOCKMSG_LEN, n3 + FLATLOCKMSG_LEN + 4);
                string2 = (String)this._idents.get(string2);
                this.setMonOwner(string, string2);
                continue;
            }
            n3 = string.indexOf(FLATLOCKMSG_WITHIDENTASDIGIT);
            if (n3 >= 0) {
                string2 = string.substring(n3 + FLATLOCKMSG_WITHIDENTASDIGIT_LEN, string.indexOf(" ", n3 + FLATLOCKMSG_WITHIDENTASDIGIT_LEN + 1));
                string2 = (String)this._idents.get(string2);
                this.setMonOwner(string, string2);
            }
            if ((n3 = string.indexOf(OWNERMSG)) < 0) continue;
            string2 = string.substring(string.indexOf("(", n3 + OWNERMSG.length()) + 1, string.indexOf(")", n3 + OWNERMSG.length()));
            this.setMonOwner(string, string2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this._ownedMonitors.keySet().iterator();
        stringBuffer.append("Owned Monitor Dump\n");
        while (iterator.hasNext()) {
            stringBuffer.append("Monitor=\n");
            String string = (String)iterator.next();
            Monitor monitor = (Monitor)this._monitors.get(string);
            stringBuffer.append(monitor.getName()).append("\n");
            stringBuffer.append(monitor._owner._threadId).append("\n");
            if (monitor._waiters.size() > 0) {
                stringBuffer.append("Waiting sys_thread_t\n");
                int n = 0;
                while (n < monitor._waiters.size()) {
                    stringBuffer.append(((Thd)monitor._waiters.get((int)n))._threadId).append("\n");
                    ++n;
                }
                continue;
            }
            stringBuffer.append("No Waiters\n");
        }
        return stringBuffer.toString();
    }

    public void addOwnedMonitor(String string, Monitor monitor) {
        this._ownedMonitors.put(string, monitor);
    }

    public Iterator getOwnedMonitorIterator() {
        return this._ownedMonitors.keySet().iterator();
    }

    public void setMonOwner(String string, String string2) {
        Thd thd;
        Monitor monitor = this.getMonitor(string);
        if (monitor != null && (thd = (Thd)this._threads.get(string2)) != null) {
            monitor.setOwner(thd);
            this.addOwnedMonitor(monitor._name, monitor);
        }
    }

    public void setMonOwner(String string) {
        Thd thd;
        String string2;
        Monitor monitor = this.getMonitor(string);
        if (monitor != null && (string2 = (String)this._tid.get(this.getMonitorStartAddress(monitor._name))) != null && (thd = (Thd)this._threads.get(string2)) != null) {
            monitor.setOwner(thd);
            this.addOwnedMonitor(monitor._name, monitor);
        }
    }

    public Monitor getMonitor(String string) {
        int n = string.indexOf(":", string.indexOf(":") + 1);
        String string2 = string.substring(0, n);
        string2 = string2.substring(string2.lastIndexOf(" ") + 1);
        return (Monitor)this._monitors.get(string2);
    }

    public String getMonitorStartAddress(String string) {
        int n = string.indexOf("@");
        int n2 = string.indexOf("/", n + 1);
        String string2 = string.substring(n + 1, n2);
        return "0x" + string2;
    }

    public Hashtable getOwnedMonitors() {
        return this._ownedMonitors;
    }
}

