/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.eclipse.hyades.internal.config.generator.Agent;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfig;
import org.eclipse.hyades.internal.config.generator.AgentControllerConfigImpl;
import org.eclipse.hyades.internal.config.generator.AgentControllerEnvironment;
import org.eclipse.hyades.internal.config.generator.Allow;
import org.eclipse.hyades.internal.config.generator.Application;
import org.eclipse.hyades.internal.config.generator.ConfigFile;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Hosts;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.Option;
import org.eclipse.hyades.internal.config.generator.Parameter;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.eclipse.hyades.internal.config.generator.Security;
import org.eclipse.hyades.internal.config.generator.UserDefinition;
import org.eclipse.hyades.internal.config.generator.Variable;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigFileImpl
extends DefaultHandler
implements ConfigFile {
    protected static String TAG = ConfigUtility.getString("Config.AgentControllerConfig.Tag");
    protected DocumentImpl doc = null;
    protected AgentControllerConfig acConfig = null;
    protected Element holder = null;
    private int size = 100;
    private Hashtable hash = new Hashtable(this.size);
    private Stack stack = null;
    private String parserName = "org.apache.xerces.parsers.SAXParser";
    private String sr = PlatformObject.sr;

    public ConfigFileImpl() {
        this.createNewDocument();
    }

    public ConfigFileImpl(String string) {
        this();
        this.loadExistingDocument(string);
    }

    public void saveToFile() {
        String string = new String(this.getValue("RASERVER_HOME") + this.sr + "config" + this.sr + "serviceconfig.xml");
        this.saveToFile(string);
    }

    public void saveToFile(String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
        }
        catch (Exception exception) {
            Logger.err(ConfigUtility.getString("Config.Writer.Error.CannotWriteFile") + " " + string);
            Logger.err(exception.getMessage());
        }
        if (printWriter != null) {
            printWriter.print(this.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml");
        String string = PlatformObject.encoding;
        String string2 = "1.0";
        try {
            object = Class.forName("org.apache.xerces.dom.CoreDocumentImpl");
            Object[] objectArray = new Class[]{};
            Method method = null;
            Method method2 = null;
            try {
                method = ((Class)object).getDeclaredMethod("getEncoding", (Class<?>[])objectArray);
                method2 = ((Class)object).getDeclaredMethod("getVersion", (Class<?>[])objectArray);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = ((Class)object).getDeclaredMethod("getXmlEncoding", (Class<?>[])objectArray);
                    method2 = ((Class)object).getDeclaredMethod("getXmlVersion", (Class<?>[])objectArray);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            if (method != null && method2 != null) {
                string = (String)method.invoke((Object)this.doc, objectArray);
                string2 = (String)method2.invoke((Object)this.doc, objectArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringBuffer.append(" version=\"" + string2 + "\"");
        stringBuffer.append(" encoding=\"" + string + "\"");
        stringBuffer.append("?>\n");
        stringBuffer.append("<!DOCTYPE");
        stringBuffer.append(" " + this.doc.getDoctype().getName());
        stringBuffer.append(" " + this.doc.getDoctype().getSystemId());
        stringBuffer.append(" " + this.doc.getDoctype().getPublicId());
        stringBuffer.append(">\n");
        object = this.holder.getChildNodes();
        if (object != null) {
            int n = 0;
            while (n < object.getLength()) {
                stringBuffer.append(ConfigUtility.print(object.item(n)));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void generateConfiguration() {
        this.generateHyadesConfiguration();
    }

    public void generateHyadesConfiguration() {
        String string = PlatformObject.sr;
        this.acConfig.setVersion(ConfigUtility.getString("Config.AgentController.Version"));
        this.acConfig.setJvm(this.resolveJvmDll(this.getValue("JAVA_PATH")));
        AgentControllerEnvironment agentControllerEnvironment = this.acConfig.addAgentControllerEnvironment("default");
        Variable variable = agentControllerEnvironment.addVariable();
        variable.setName("JAVA_PATH");
        variable.setValue(this.getValue("JAVA_PATH"));
        variable.setPosition("replace");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("RASERVER_HOME");
        variable.setValue(this.getValue("RASERVER_HOME"));
        variable.setPosition("replace");
        variable = agentControllerEnvironment.addVariable();
        variable.setName(PlatformObject.libEnv);
        variable.setValue("%RASERVER_HOME%" + string + PlatformObject.libPath);
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hcframe.jar");
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hexl.jar");
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hexr.jar");
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hexcore.jar");
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hlcore.jar");
        variable.setPosition("prepend");
        variable = agentControllerEnvironment.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hlevents.jar");
        variable.setPosition("prepend");
        Application application = this.acConfig.addApplication("default", "java.exe");
        application.setPath("%JAVA_PATH%");
        application.setLocation(PlatformObject.tempDir);
        application = this.acConfig.addApplication("default", "RemoteLogParserLoader");
        application.setPath("%JAVA_PATH%");
        application.setLocation("%RASERVER_HOME%" + string + "config");
        Parameter parameter = application.addParameter();
        parameter.setValue("org.eclipse.hyades.logging.parsers.RemoteLogParserLoader");
        parameter.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "commons-logging.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hlcommons.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hparse.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hglaconfig.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hgla.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "jakarta-oro.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "xercesImpl.jar");
        variable.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "xmlParserAPIs.jar");
        variable.setPosition("prepend");
        application = this.acConfig.addApplication("default", "HyadesTestingSession");
        application.setPath("%JAVA_PATH%");
        application.setLocation(PlatformObject.tempDir);
        parameter = application.addParameter();
        parameter.setValue("&quot;-Dhyades.test.JVM=%JAVA_PATH%&quot;");
        parameter.setPosition("prepend");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "common.runner.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "java.runner.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "http.runner.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "junit.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "xerces.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "xercesImpl.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "manual.runner.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "hexrecr.jar");
        variable.setPosition("append");
        variable = application.addVariable();
        variable.setName("CLASSPATH");
        variable.setValue("%RASERVER_HOME%" + string + "lib" + string + "http.hexrecr.jar");
        variable.setPosition("append");
        application = this.acConfig.addApplication("default", "PerfmonAgent");
        application.setPath("%RASERVER_HOME%" + string + "bin" + string + "PerfmonAgent" + PlatformObject.exeExt);
        application.setLocation("%RASERVER_HOME%" + string + "bin");
        Hosts hosts = this.acConfig.addHosts("default");
        if (this.getValue("ALLOW") != null) {
            if (this.getValue("ALLOW").toLowerCase().equals("custom")) {
                String[] stringArray = ConfigUtility.stringToArray(this.getValue("HOSTS"));
                if (stringArray.length > 0) {
                    int n = 0;
                    while (n < stringArray.length) {
                        Allow allow = hosts.addAllow();
                        if (stringArray[n].equalsIgnoreCase("all") || stringArray[n].equalsIgnoreCase("local")) {
                            allow.setHost(stringArray[n].toUpperCase());
                        } else {
                            allow.setHost(stringArray[n]);
                        }
                        ++n;
                    }
                } else {
                    Allow allow = hosts.addAllow();
                    allow.setHost("LOCAL");
                }
            } else {
                Allow allow = hosts.addAllow();
                allow.setHost(this.getValue("ALLOW").toUpperCase());
            }
        } else {
            Allow allow = hosts.addAllow();
            allow.setHost("LOCAL");
        }
        Agent agent = this.acConfig.addAgent("default", "Java Profiling Agent");
        agent.setType("Profiler");
        agent.setDataChannelSize(PlatformObject.dataSize);
        agent.setClient("DYNAMIC");
        Option option = this.acConfig.addOption("Thread Analysis Agent");
        option.setType("Profiler");
        option.setValue("hcthread");
    }

    public void createNewDocument() {
        DOMImplementation dOMImplementation = DOMImplementationImpl.getDOMImplementation();
        DocumentTypeImpl documentTypeImpl = null;
        documentTypeImpl = (DocumentTypeImpl)dOMImplementation.createDocumentType(TAG, "\"../dtd/serviceconfig.dtd\"", "SYSTEM");
        this.doc = (DocumentImpl)dOMImplementation.createDocument(null, TAG, (DocumentType)documentTypeImpl);
        try {
            Class<?> clazz = Class.forName("org.apache.xerces.dom.CoreDocumentImpl");
            Class[] classArray = new Class[]{new String().getClass()};
            Method method = null;
            Method method2 = null;
            try {
                method = clazz.getDeclaredMethod("setEncoding", classArray);
                method2 = clazz.getDeclaredMethod("setVersion", classArray);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = clazz.getDeclaredMethod("setXmlEncoding", classArray);
                    method2 = clazz.getDeclaredMethod("setXmlVersion", classArray);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            if (method != null && method2 != null) {
                Object[] objectArray = new String[]{new String(PlatformObject.encoding)};
                Object[] objectArray2 = new String[]{new String("1.0")};
                method.invoke((Object)this.doc, objectArray);
                method2.invoke((Object)this.doc, objectArray2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.holder = this.doc.createElement("ElementHolder");
        this.acConfig = new AgentControllerConfigImpl((CoreDocumentImpl)this.doc);
        this.acConfig.setActiveConfiguration("default");
        this.acConfig.setLoggingDetail("LOW");
        this.acConfig.setLoggingLevel("WARNING");
        this.acConfig.setPort("10002");
        this.acConfig.setSecurePort("10003");
        this.acConfig.setVersion(ConfigUtility.getString("Config.AgentController.Version"));
        this.holder.appendChild(this.acConfig);
    }

    public void loadExistingDocument(String string) {
        block5: {
            XMLReader xMLReader = null;
            this.stack = new Stack();
            try {
                xMLReader = XMLReaderFactory.createXMLReader(this.parserName);
                xMLReader.setContentHandler(this);
                xMLReader.setErrorHandler(this);
            }
            catch (Exception exception) {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.CreateParser") + " " + this.parserName);
                Logger.err(exception.getMessage());
            }
            if (xMLReader != null) {
                try {
                    xMLReader.parse(string);
                }
                catch (Exception exception) {
                    Exception exception2;
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.ParseFile") + " " + string);
                    Logger.err(exception.getMessage());
                    if (!(exception instanceof SAXException) || (exception2 = ((SAXException)exception).getException()) == null) break block5;
                    Logger.err(exception2.getMessage());
                }
            }
        }
    }

    public void startDocument() throws SAXException {
        this.createNewDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals(AgentControllerConfig.TAG)) {
            if (this.stack.empty()) {
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.ActiveConfig.Tag"))) {
                        this.acConfig.setActiveConfiguration(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Jvm.Tag"))) {
                        this.acConfig.setJvm(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.LoggingDetail.Tag"))) {
                        this.acConfig.setLoggingDetail(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.LoggingLevel.Tag"))) {
                        this.acConfig.setLoggingLevel(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Port.Tag"))) {
                        this.acConfig.setPort(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.SecurePort.Tag"))) {
                        this.acConfig.setSecurePort(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Version.Tag"))) {
                        this.acConfig.setVersion(attributes.getValue(n));
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"))) {
                        this.acConfig.setConfiguration(attributes.getValue(n));
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                this.holder.appendChild(this.acConfig);
                this.stack.push(this.acConfig);
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(AgentControllerEnvironment.TAG)) {
            if (this.stack.peek() instanceof AgentControllerConfig) {
                AgentControllerEnvironment agentControllerEnvironment = null;
                String string4 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"))) {
                        string4 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string4 != null) {
                    agentControllerEnvironment = ((AgentControllerConfig)this.stack.peek()).addAgentControllerEnvironment(string4);
                }
                if (agentControllerEnvironment != null) {
                    this.stack.push(agentControllerEnvironment);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Application.TAG)) {
            if (this.stack.peek() instanceof AgentControllerConfig) {
                Application application = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"))) {
                        string5 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Application.Executable.Tag"))) {
                        string6 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Application.Location.Tag"))) {
                        string7 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Application.Path.Tag"))) {
                        string8 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string5 != null && string6 != null) {
                    application = ((AgentControllerConfig)this.stack.peek()).addApplication(string5, string6);
                    application.setLocation(string7);
                    application.setPath(string8);
                }
                if (application != null) {
                    this.stack.push(application);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Hosts.TAG)) {
            if (this.stack.peek() instanceof AgentControllerConfig) {
                Hosts hosts = null;
                String string9 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"))) {
                        string9 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string9 != null) {
                    hosts = ((AgentControllerConfig)this.stack.peek()).addHosts(string9);
                }
                if (hosts != null) {
                    this.stack.push(hosts);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Agent.TAG)) {
            if (this.stack.peek() instanceof AgentControllerConfig) {
                Agent agent = null;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.AgentControllerConfig.Configuration.Tag"))) {
                        string10 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Agent.DataChannelSize.Tag"))) {
                        string12 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Agent.Name.Tag"))) {
                        string11 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Agent.Type.Tag"))) {
                        string13 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string10 != null && string11 != null) {
                    agent = ((AgentControllerConfig)this.stack.peek()).addAgent(string10, string11);
                    agent.setDataChannelSize(string12);
                    agent.setType(string13);
                }
                if (agent != null) {
                    this.stack.push(agent);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Option.TAG)) {
            if (this.stack.peek() instanceof Agent) {
                Option option = null;
                String string14 = null;
                String string15 = null;
                String string16 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Option.Name.Tag"))) {
                        string14 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Option.Type.Tag"))) {
                        string15 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Option.Value.Tag"))) {
                        string16 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string14 != null && string15 != null && string16 != null) {
                    option = ((Agent)this.stack.peek()).addOption();
                    option.setName(string14);
                    option.setType(string15);
                    option.setValue(string16);
                }
                if (option != null) {
                    this.stack.push(option);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Security.TAG)) {
            if (this.stack.peek() instanceof AgentControllerConfig) {
                Security security = null;
                String string17 = null;
                String string18 = null;
                String string19 = null;
                String string20 = null;
                String string21 = null;
                String string22 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.AclEnabled.Tag"))) {
                        string17 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.ClientAuthenticate.Tag"))) {
                        string18 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.Keystore.Tag"))) {
                        string19 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.KeystoreManager.Tag"))) {
                        string20 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.KeystorePassword.Tag"))) {
                        string21 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Security.Provider.Tag"))) {
                        string22 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string17 != null && string18 != null && string19 != null && string20 != null && string21 != null && string22 != null) {
                    security = ((AgentControllerConfig)this.stack.peek()).addSecurity();
                    security.setAclEnabled(string17);
                    security.setClientAuthenticate(string18);
                    security.setKeystore(string19);
                    security.setKeystoreManager(string20);
                    security.setKeystorePassword(string21);
                    security.setProvider(string22);
                    this.setValue("SECURITY", "true");
                } else {
                    this.setValue("SECURITY", "false");
                }
                if (security != null) {
                    this.stack.push(security);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(UserDefinition.TAG)) {
            if (this.stack.peek() instanceof Security) {
                UserDefinition userDefinition = null;
                String string23 = null;
                String string24 = null;
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.UserDefinition.AuthenticationType.Tag"))) {
                        string23 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.UserDefinition.Name.Tag"))) {
                        string24 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string23 != null && string24 != null) {
                    userDefinition = ((Security)this.stack.peek()).addUserDefinition();
                    userDefinition.setAuthenticationType(string23);
                    userDefinition.setName(string24);
                    if (this.getValue("USERS") == null) {
                        this.setValue("USERS", string24);
                    } else {
                        this.setValue("USERS", this.getValue("USERS") + "," + string24);
                    }
                }
                if (string23 != null) {
                    this.stack.push(string23);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.MissingConfiguration") + " " + string2);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Variable.TAG)) {
            Variable variable = null;
            String string25 = null;
            String string26 = null;
            String string27 = null;
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Variable.Name.Tag"))) {
                    string25 = attributes.getValue(n);
                } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Variable.Value.Tag"))) {
                    string26 = attributes.getValue(n);
                } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Variable.Position.Tag"))) {
                    string27 = attributes.getValue(n);
                } else {
                    Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                }
                ++n;
            }
            if (string25 != null && string26 != null && string27 != null) {
                if (this.stack.peek() instanceof AgentControllerEnvironment) {
                    variable = ((AgentControllerEnvironment)this.stack.peek()).addVariable();
                    variable.setName(string25);
                    variable.setValue(string26);
                    variable.setPosition(string27);
                    if (!string25.equals("CLASSPATH") && !string25.equals("PATH")) {
                        this.setValue(string25, string26);
                    }
                } else if (this.stack.peek() instanceof Application) {
                    variable = ((Application)this.stack.peek()).addVariable();
                    variable.setName(string25);
                    variable.setValue(string26);
                    variable.setPosition(string27);
                } else {
                    Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
                }
            }
            if (variable != null) {
                this.stack.push(variable);
            }
        } else if (string2.equals(Parameter.TAG)) {
            Parameter parameter = null;
            String string28 = null;
            String string29 = null;
            if (this.stack.peek() instanceof Application) {
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Parameter.Value.Tag"))) {
                        string28 = attributes.getValue(n);
                    } else if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Parameter.Position.Tag"))) {
                        string29 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string28 != null && string29 != null) {
                    parameter = ((Application)this.stack.peek()).addParameter();
                    parameter.setValue(string28);
                    parameter.setPosition(string29);
                }
                if (parameter != null) {
                    this.stack.push(parameter);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else if (string2.equals(Allow.TAG)) {
            Allow allow = null;
            String string30 = null;
            if (this.stack.peek() instanceof Hosts) {
                int n = 0;
                while (n < attributes.getLength()) {
                    if (attributes.getLocalName(n).equals(ConfigUtility.getString("Config.Allow.Host.Tag"))) {
                        string30 = attributes.getValue(n);
                    } else {
                        Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedAttribute") + " " + attributes.getLocalName(n));
                    }
                    ++n;
                }
                if (string30 != null) {
                    allow = ((Hosts)this.stack.peek()).addAllow();
                    allow.setHost(string30);
                    if (string30.toLowerCase().equals("all") || string30.toLowerCase().equals("local")) {
                        this.setValue("ALLOW", string30.toUpperCase());
                        this.removeKey("HOSTS");
                    } else {
                        this.setValue("ALLOW", "CUSTOM");
                        if (this.getValue("HOSTS") == null) {
                            this.setValue("HOSTS", string30);
                        } else {
                            this.setValue("HOSTS", this.getValue("HOSTS") + "," + string30);
                        }
                    }
                }
                if (allow != null) {
                    this.stack.push(allow);
                }
            } else {
                Logger.err(ConfigUtility.getString("Config.Parser.Error.OwnerNodeMismatch"));
            }
        } else {
            Logger.out(ConfigUtility.getString("Config.Parser.Warning.UnrecognizedElement") + " " + string2);
            this.stack.push(null);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.stack.pop();
    }

    public String resolveJvmDll(String string) {
        if (PlatformObject.name.equals("OS/400")) {
            return this.getValue("JAVA_PATH");
        }
        String string2 = string.substring(0, string.lastIndexOf("java"));
        String string3 = null;
        try {
            string3 = ConfigUtility.getJvmLib(string2);
        }
        catch (Exception exception) {
            Logger.out(ConfigUtility.getString("Config.Jvm.Warning.CannotFindJvmLibrary") + ": " + PlatformObject.jvmLib);
        }
        return string3;
    }

    public AgentControllerConfig getAcConfig() {
        return this.acConfig;
    }

    public String getValue(String string) {
        return (String)this.hash.get(string);
    }

    public void setValue(String string, String string2) {
        this.hash.put(string, string2);
    }

    public void removeKey(String string) {
        this.hash.remove(string);
    }

    public boolean isExist(String string) {
        return this.hash.containsKey(string);
    }
}

