/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.ConnectionObj;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;

public class ServerSideReader
extends Thread {
    InputStream from_server;
    OutputStream to_spySocket;
    InputStream from_sslPassThroughStream;
    OutputStream to_client;
    FileOutputStream to_file;
    PacketWriter packetWriter = null;
    boolean bSecure;
    boolean bClosedByClient = false;
    int iConnection = 0;
    int iReceiveBufSize = 0;
    Socket client;
    Socket server;
    ConnectionObj connectionNumber;
    byte[] ssrBuffer = null;

    ServerSideReader(Socket socket, Socket socket2, InputStream inputStream, OutputStream outputStream, PacketWriter packetWriter, ConnectionObj connectionObj, boolean bl, int n) {
        this.client = socket;
        this.server = socket2;
        this.from_server = inputStream;
        this.to_client = outputStream;
        this.packetWriter = packetWriter;
        this.bSecure = bl;
        this.iConnection = connectionObj.getConnectionNumber();
        this.connectionNumber = connectionObj;
        this.iReceiveBufSize = n;
    }

    public void setClosedByClient() {
        this.bClosedByClient = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.ssrBuffer = new byte[this.iReceiveBufSize];
        int n = 0;
        this.setName("ServerSideReader-Conn:" + this.iConnection);
        try {
            while ((n = this.from_server.read(this.ssrBuffer)) >= 0) {
                this.packetWriter.writePacket(this.bSecure, false, this.connectionNumber, this.ssrBuffer, n);
                this.to_client.write(this.ssrBuffer, 0, n);
                this.to_client.flush();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string.indexOf("Stream closed") < 0 && string.indexOf("Socket closed") < 0 && string.indexOf("JVM_recv in socket input") < 0 && string.indexOf("onnection closed") < 0 && string.indexOf("socket closed") < 0 && string.indexOf("onnection reset") < 0 && string.indexOf("Socket is closed") < 0) {
                this.packetWriter.writeRecorderMessage(2, "exception in ServerSideReader connection " + this.iConnection + " : " + exception.getLocalizedMessage());
            }
        }
        finally {
            try {
                this.packetWriter.writeCloseConnectionInfo(this.connectionNumber);
                if (this.client != null && !this.client.isOutputShutdown() && !this.client.isClosed()) {
                    this.client.shutdownOutput();
                }
            }
            catch (Exception exception) {
                this.packetWriter.writeRecorderMessage(2, "exception in ServerSideReader executing finally block connection " + this.iConnection + " : " + exception.getLocalizedMessage());
            }
        }
    }
}

