/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.hierarchy;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class XMLprocessCreateLoader
extends IgnoredXMLFragmentLoader {
    private String application_executable;
    private String pName;
    private String nodeIdRef;
    private String processId;
    private TRCProcessProxy process;
    private int pid;

    public void addAttribute(String name, String value) {
        if (name.equals("processId")) {
            this.processId = value;
        } else if (name.equals("nodeIdRef")) {
            this.nodeIdRef = value;
        } else if (name.equals("name")) {
            this.pName = value;
        } else if (name.equals("pid")) {
            this.pid = Integer.valueOf(value);
        } else if (name.equals("application_executable")) {
            this.application_executable = value;
        }
    }

    public void addYourselfInContext() {
        String id;
        Iterator i;
        EList list;
        TRCMonitor monitor = this.context.getMonitor();
        if (monitor == null) {
            return;
        }
        TRCNode node = this.context.getNode();
        if (node == null) {
            list = monitor.getNodes();
            i = list.iterator();
            while (i.hasNext()) {
                node = (TRCNode)i.next();
                if (node.eIsProxy() || (id = node.getRuntimeId()) == null || !id.equals(this.nodeIdRef)) continue;
                this.context.setNode(node);
                break;
            }
        } else if (node.getRuntimeId() != null && !node.getRuntimeId().equals(this.nodeIdRef)) {
            list = monitor.getNodes();
            i = list.iterator();
            while (i.hasNext()) {
                node = (TRCNode)i.next();
                if (node.eIsProxy() || (id = node.getRuntimeId()) == null || !id.equals(this.nodeIdRef)) continue;
                this.context.setNode(node);
                break;
            }
        }
        this.process = LoadersUtils.locateProcessFromNode(node, this.pid, this.processId);
        if (this.process == null) {
            String monitorFolder = LoadersUtils.getMonitorFolder(monitor);
            Resource procDoc = null;
            if (monitorFolder != null) {
                String pName = StringUtil.change(monitor.getName().trim(), " ", "") + "_" + node.getName().trim() + "_" + this.pid + "_" + this.processId;
                String pFileName = monitorFolder + pName;
                procDoc = Resource.Factory.Registry.INSTANCE.getFactory(SaveUtil.createURI(pFileName + ".trcpxmi")).createResource(SaveUtil.createURI(pFileName + ".trcpxmi"));
                procDoc.setModified(true);
                HierarchyResourceSetImpl.getInstance().getResources().add((Object)procDoc);
            }
            this.process = HierarchyFactory.eINSTANCE.createTRCProcessProxy();
            this.process.setPid(this.pid);
            if (this.processId != null) {
                this.process.setRuntimeId(this.processId);
            } else {
                this.process.setRuntimeId("0");
            }
            this.process.setNode(node);
            this.setProcessArguments(this.process);
            node.getProcessProxies().add((Object)this.process);
            this.context.setProcessProxy(this.process);
            if (procDoc != null) {
                procDoc.getContents().add((Object)this.process);
            }
        } else {
            this.process.setRuntimeId(this.processId);
            this.context.setProcessProxy(this.process);
        }
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        this.processId = "0";
        this.nodeIdRef = "0";
        this.application_executable = "";
        this.pName = "unknown";
        this.process = null;
        this.pid = -1;
    }

    private void setProcessArguments(TRCProcessProxy process) {
        if (this.application_executable == null) {
            return;
        }
        String params = "";
        String vmparam = "";
        String classpath = "";
        int java_index = this.application_executable.indexOf("java.exe");
        if (java_index < 0) {
            java_index = this.application_executable.indexOf("javaw.exe");
            if (java_index > 0) {
                java_index += "javaw.exe".length();
            }
        } else {
            java_index += "java.exe".length();
        }
        if (java_index > 0) {
            String exeName = this.application_executable.substring(java_index).trim();
            int idx = exeName.indexOf(" ");
            if (!exeName.startsWith("-") && idx != -1 && idx < exeName.length() + 1) {
                exeName = exeName.substring(idx + 1);
            }
            while (exeName.startsWith("-")) {
                if (exeName.startsWith("-cp") || exeName.startsWith("-classpath")) {
                    idx = exeName.indexOf(" ");
                    if (idx != -1) {
                        exeName = exeName.substring(idx).trim();
                    }
                    if ((idx = exeName.indexOf(" ")) == -1) continue;
                    classpath = exeName.substring(0, idx);
                    exeName = exeName.substring(idx).trim();
                    continue;
                }
                idx = exeName.indexOf(" ");
                if (idx == -1) continue;
                vmparam = vmparam + exeName.substring(0, idx) + " ";
                exeName = exeName.substring(idx).trim();
            }
            idx = exeName.indexOf(" ");
            if (idx != -1) {
                if (this.pName.equals("unknown")) {
                    this.pName = exeName.substring(0, idx);
                }
                params = exeName.substring(idx).trim();
            } else if (this.pName.equals("unknown") && exeName.trim().length() > 0) {
                this.pName = exeName;
            }
        }
        process.setName(this.pName);
        process.setClasspath(classpath);
        process.setParameters(params);
        process.setVmArguments(vmparam);
        process.setLaunchMode(1);
    }
}

