/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class FileUtil {
    public static File getTempDir() {
        GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
        String tmpdir = AccessController.doPrivileged(a);
        return new File(tmpdir);
    }

    public static boolean copyFile(String srcFile, String destFile) {
        try {
            FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
            FileChannel destChannel = new FileOutputStream(destFile).getChannel();
            destChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            destChannel.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static File[] listAllFiles(File srcDir) {
        Vector<File> files = new Vector<File>();
        File[] ret = new File[]{};
        File[] children = srcDir.listFiles();
        if (children == null) {
            return null;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isFile()) {
                files.add(children[i]);
            } else {
                File[] sub = FileUtil.listAllFiles(children[i]);
                int j = 0;
                while (j < sub.length) {
                    files.add(sub[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (files.isEmpty()) {
            return null;
        }
        return files.toArray(ret);
    }

    public static boolean deltree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    FileUtil.deltree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }
}

